#include "gui/pages/now_playing.h"
#include "core/anime_db.h"
#include "core/strings.h"
#include "gui/widgets/anime_info.h"
#include "gui/widgets/text.h"
#include "gui/widgets/poster.h"

#include <QLabel>
#include <QStackedWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QWidget>

#include "anitomy/anitomy.h"

namespace NowPlayingPages {

class Default : public QWidget {
		Q_OBJECT

	public:
		Default(QWidget* parent = nullptr);
};

class Playing : public QWidget {
		Q_OBJECT

	public:
		Playing(QWidget* parent = nullptr);
		void SetPlayingAnime(const Anime::Anime& anime, const anitomy::Elements& info);
		int GetPlayingAnime();

	private:
		int _id = 0;
		int _episode = 0;
		std::unique_ptr<QWidget> _main = nullptr;
		std::unique_ptr<TextWidgets::Title> _title = nullptr;
		std::unique_ptr<AnimeInfoWidget> _info = nullptr;
		std::unique_ptr<QWidget> _sidebar = nullptr;
		std::unique_ptr<Poster> _poster = nullptr;
};

Default::Default(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);
	layout->setContentsMargins(0, 0, 0, 0);

	TextWidgets::Title* title = new TextWidgets::Title(tr("Now Playing"), this);
	layout->addWidget(title);

	layout->addStretch();
}

Playing::Playing(QWidget* parent) : QWidget(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);

	_main.reset(new QWidget(this));
	_main->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);

	QVBoxLayout* main_layout = new QVBoxLayout(_main.get());
	main_layout->setContentsMargins(0, 0, 0, 0);

	_title.reset(new TextWidgets::Title("", _main.get()));
	main_layout->addWidget(_title.get());

	_info.reset(new AnimeInfoWidget(_main.get()));
	_info->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	_info->layout()->setContentsMargins(0, 0, 0, 0);
	main_layout->addWidget(_info.get());

	/* "sidebar", includes... just the anime image :) */
	_sidebar.reset(new QWidget(this));
	QVBoxLayout* sidebar_layout = new QVBoxLayout(_sidebar.get());
	sidebar_layout->setContentsMargins(0, 0, 0, 0);

	_poster.reset(new Poster(_sidebar.get()));
	sidebar_layout->addWidget(_poster.get());

	sidebar_layout->addStretch();

	layout->addWidget(_sidebar.get());
	layout->addWidget(_main.get());
	layout->setSpacing(10);
	layout->setContentsMargins(0, 0, 0, 0);
}

int Playing::GetPlayingAnime() {
	return _id;
}

void Playing::SetPlayingAnime(const Anime::Anime& anime, const anitomy::Elements& info) {
	if (_id == anime.GetId() && _episode == Strings::ToInt(Strings::ToUtf8String(info.get(anitomy::kElementEpisodeNumber))))
		return;
	_id = anime.GetId();
	_episode = Strings::ToInt(Strings::ToUtf8String(info.get(anitomy::kElementEpisodeNumber)));
	_title->SetText(Strings::ToQString(anime.GetUserPreferredTitle()));
	_info->SetAnime(anime);
	_poster->SetAnime(anime);

	updateGeometry();
}

} // namespace NowPlayingPages

NowPlayingPage::NowPlayingPage(QWidget* parent) : QFrame(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);

	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Sunken);
	setAutoFillBackground(true);

	stack = new QStackedWidget(this);
	stack->addWidget(new NowPlayingPages::Default(stack));
	stack->addWidget(new NowPlayingPages::Playing(stack));
	layout->addWidget(stack);

	SetDefault();
}

void NowPlayingPage::SetDefault() {
	stack->setCurrentIndex(0);
}

int NowPlayingPage::GetPlayingId() {
	return reinterpret_cast<NowPlayingPages::Playing*>(stack->widget(1))->GetPlayingAnime();
}

void NowPlayingPage::SetPlaying(const Anime::Anime& anime, const anitomy::Elements& info) {
	reinterpret_cast<NowPlayingPages::Playing*>(stack->widget(1))->SetPlayingAnime(anime, info);
	stack->setCurrentIndex(1);
	updateGeometry();
}

#include "gui/pages/moc_now_playing.cpp"
#include "now_playing.moc"
