#ifndef MINORI_GUI_DIALOG_INFORMATION_H_
#define MINORI_GUI_DIALOG_INFORMATION_H_

#include "core/anime.h"
#include "core/date.h"
#include "gui/dialog/dialog.h"
#include <functional>

class InformationDialog final : public Dialog {
	Q_OBJECT

public:
	enum Pages {
		PAGE_MAIN_INFO,
		PAGE_MY_LIST
	};

	/* weird, the page should be first
	 * also this should take an anime ID, rather than a pointer  --paper */
	InformationDialog(Anime::Anime* anime, std::function<void(Anime::Anime*)> accept = {}, enum Pages page = Pages::PAGE_MAIN_INFO,
	                  QWidget* parent = nullptr);

private:
	void SaveData(Anime::Anime* anime);
	unsigned int _progress;
	unsigned int _score;
	bool _rewatching;
	Anime::ListStatus _status;
	std::string _notes;
	Date _started;
	Date _completed;
};

#endif // MINORI_GUI_DIALOG_INFORMATION_H_
