#ifndef MINORI_LIBRARY_LIBRARY_H_
#define MINORI_LIBRARY_LIBRARY_H_

#include "core/filesystem.h"
#include "library/library.h"

#include <filesystem>
#include <optional>
#include <unordered_map>

namespace Library {

class Database final {
public:
	Database();

	/* Update watchers from current library paths */
	void UpdateWatchers();

	bool GetPathAnimeAndEpisode(const std::string &basename, int *aid, int *ep);

	void EventHandler(const std::filesystem::path &path, Filesystem::IWatcher::Event event);
	static void StaticEventHandler(void *opaque, const std::filesystem::path &path, Filesystem::IWatcher::Event event);

	std::optional<std::filesystem::path> GetAnimeFolder(int id);
	void Refresh();
	void Refresh(int id);

	// Anime episodes. Indexed as `folders[id][episode]'
	std::unordered_map<int, std::unordered_map<int, std::filesystem::path>> items;

private:
	void Refresh(std::optional<int> find_id);

	std::unordered_map<std::filesystem::path, std::unique_ptr<Filesystem::IWatcher>> watchers_;

	/* ID we're looking for */
	std::optional<int> find_id_;
};

extern Database db;

} // namespace Library

#endif // MINORI_LIBRARY_LIBRARY_H_
