#include "animia/win.h"

#ifdef WIN32
#	include "animia/win/win32.h"
#elif MACOSX
#	include "animia/win/quartz.h"
#endif

namespace animia::internal {

#ifdef WIN32
win32::Win32WinTools os_win;
#elif MACOSX
quartz::QuartzWinTools os_win;
#elif X11
x11::X11WinTools os_win;
#else
BaseWinTools os_win;
#endif

BaseWinTools& win = os_win;

} // namespace animia::internal
