#ifndef __window_h
#define __window_h
#include "core/config.h"
#include <QMainWindow>
#include <memory>

/* *could* be forward-declared, but this causes
   any file that #includes this to have to #include
   these as well due to unique_ptr */
#include <QWidget>
#include <QStackedWidget>
#include <QCloseEvent>
#include "gui/widgets/sidebar.h"

class MainWindow final : public QMainWindow {
		Q_OBJECT

	public:
		MainWindow(QWidget* parent = nullptr);
		void SetActivePage(QWidget* page);
		void CreateBars();
		void AddMainWidgets();
		void RetranslateUI();
		void AsyncSynchronize(QStackedWidget* stack);
		void changeEvent(QEvent* event) override;
		void showEvent(QShowEvent* event) override;
		void closeEvent(QCloseEvent* event) override;

	private:
		std::unique_ptr<QWidget> main_widget = nullptr;
		std::unique_ptr<QStackedWidget> stack = nullptr;
		std::unique_ptr<SideBar> sidebar = nullptr;
};

#endif // __window_h
