#ifndef __core__config_h
#define __core__config_h

#include "core/anime.h"
#include "gui/theme.h"
#include "gui/locale.h"

#include "animia/player.h"

#include <string>
#include <vector>
#include <utility>

struct MediaPlayer {
	bool enabled = true;
	animia::Player player;
};

class Config {
	public:
		int Load();
		int Save() const;

		Anime::Services service;
		Theme::Theme theme;
		Locale::Locale locale;

		struct {
			public:
				Anime::TitleLanguage language;
				Anime::ScoreFormat score_format;
				bool display_aired_episodes;
				bool display_available_episodes;
				bool highlight_anime_if_available;
				bool highlighted_anime_above_others;
		} anime_list;

		/* these should preferably be in an
		   "auth" struct... */
		struct {
			public:
				struct {
					public:
						std::string auth_token;
						std::string username;
						int user_id;
				} anilist;
		} auth;

		struct {
			public:
				bool detect_media_players;
				std::vector<MediaPlayer> players;
		} recognition;

		struct {
			public:
				std::string feed_link;
		} torrents;
};

#define WIDEIFY_EX(x) L##x
#define WIDEIFY(x)    WIDEIFY_EX(x)

/* only on these platforms keep this uppercase.
   this will not remove compatibility with older
   versions, since these platforms are case insensitive
   (on macOS, only by default) */
#if (defined(WIN32) || defined(MACOSX))
#define CONFIG_DIR    "Minori"
#else
#define CONFIG_DIR    "minori"
#endif

#define CONFIG_WDIR   WIDEIFY(CONFIG_DIR)
#define CONFIG_NAME   "config.ini"
#define CONFIG_WNAME  WIDEIFY(CONFIG_NAME)

#define MAX_LINE_LENGTH 256

#endif // __core__config_h
