# Animia
Animia is a work-in-progress cross-platform hard fork of Anisthesia and part of
Minori.

Most (if not all) Anisthesia configs should also work in this library as well
(at least on Windows).

## License
Changes divergent from Anisthesia are under the BSD 3-clause license. You can
find a copy of the original MIT license bundled with Anisthesia at `LICENSE.MIT`
in the root folder.

## Support
Unlike Anisthesia, Animia currently does not support UI automation, i.e., most
web browsers will not work properly, if at all.

Animia will first attempt to connect to a windowing system. If that fails, it falls
back to just enumerating over the open processes in the system.

## Platform-specific quirks

### Windows
To get the currently opened file handles on Windows, Animia has to use internal
kernel functions. However, these functions aren't likely to change anytime soon.

### macOS
The code to retrieve executable names on macOS uses internal functions. However,
if these functions cannot be found for whatever reason, it falls back to parsing
the arguments, and then to calling the kernel.

Additionally, macOS does not have the concept of class names, rather, it has
bundle identifiers, which are a suitable replacement in most use cases, and are
what Animia will try to grab before falling back to the Quartz window name.

### X11
Animia requires that the XRes extension is installed to retrieve window PIDs.
