#ifndef ANIMONE_ANIMONE_UTIL_OSX_H_
#define ANIMONE_ANIMONE_UTIL_OSX_H_

#include "animone/types.h"
#include <cstdint>
#include <string>

#include <CoreFoundation/CoreFoundation.h>

namespace animone::internal::osx::util {

template<typename T>
bool GetCFNumber(CFNumberRef num, T& result) {
	if (!num)
		return false;

	int64_t res;
	if (!CFNumberGetValue(num, static_cast<CFNumberType>(4), &res))
		return false;

	result = static_cast<T>(res);
	return true;
}

template<typename T>
struct CFDeconstructor {
	using pointer = T;
	void operator()(pointer t) const { ::CFRelease(t); };
};

template<typename T>
using CFPtr = vector<T, CFDecontructor<T>>; // type-id is vector<T, Alloc<T>>

bool StringFromCFString(CFStringRef string, std::string& result);

bool GetProcessName(pid_t pid, std::string& result);

} // namespace animone::internal::osx::util

#endif // ANIMONE_ANIMONE_UTIL_OSX_H_
