#ifndef ANIMONE_ANIMONE_UTIL_WIN32_H_
#define ANIMONE_ANIMONE_UTIL_WIN32_H_

#include <subauth.h>
#include <windows.h>

#include <memory>
#include <string>

namespace animone::internal::win32 {

struct HandleDeconstructor {
	using pointer = HANDLE;
	void operator()(pointer t) const { ::CloseHandle(t); };
};

using Handle = std::unique_ptr<HANDLE, HandleDeconstructor>;

/* ----------------------------------------------- */

std::string ToUtf8String(const std::wstring& string);
std::string ToUtf8String(const UNICODE_STRING& string);
std::wstring ToWstring(const std::string& string);

std::wstring GetFileNameFromPath(const std::wstring& path);
std::wstring GetFileNameWithoutExtension(const std::wstring& filename);

bool IsSystemDirectory(const std::string& path);
bool IsSystemDirectory(std::wstring path);

} // namespace animone::internal::win32

#endif // ANIMONE_ANIMONE_UTIL_WIN32_H_