#ifndef MINORI_CORE_CONFIG_H_
#define MINORI_CORE_CONFIG_H_

#include "core/anime.h"
#include "gui/locale.h"
#include "gui/theme.h"

#include "animone/player.h"

#include <set>
#include <string>
#include <utility>
#include <vector>

struct MediaPlayer {
	bool enabled = true;
	animone::Player player;
};

class Config {
public:
	int Load();
	int Save();

	Anime::Services service;
	Theme::Theme theme;
	Locale::Locale locale;

	struct {
		Anime::TitleLanguage language;
		Anime::ScoreFormat score_format;
		bool display_aired_episodes;
		bool display_available_episodes;
		bool highlight_anime_if_available;
		bool highlighted_anime_above_others;
	} anime_list;

	struct {
		struct {
			std::string auth_token;
			int user_id;
		} anilist;
	} auth;

	struct {
		bool detect_media_players;
		std::vector<MediaPlayer> players;
	} recognition;

	struct {
		std::string feed_link;
	} torrents;

	struct {
		bool real_time_monitor;
		std::set<std::string> paths;
	} library;
};

#if (defined(WIN32) || defined(MACOSX))
constexpr std::string_view CONFIG_DIR = "Minori";
#else
constexpr std::string_view CONFIG_DIR = "minori";
#endif

constexpr std::string_view CONFIG_NAME = "config.ini";

#endif // MINORI_CORE_CONFIG_H_
