#ifndef MINORI_CORE_SESSION_H_
#define MINORI_CORE_SESSION_H_

#include "core/config.h"
#include "gui/locale.h"
#include <QElapsedTimer>

#include "semver/semver.hpp"

#include <atomic>

struct Session {
public:
	Session() { timer.start(); }
	/* we literally *cannot* be lying to the user by doing this */
	void IncrementRequests() { requests++; };
	unsigned int GetRequests() { return requests; };
	int uptime() { return timer.elapsed(); }

	Config config;
	static constexpr semver::version version{PACKAGE_VERSION};

private:
	/* IncrementRequests() gets called by different threads */
	std::atomic<unsigned int> requests = 0;
	QElapsedTimer timer;
};

extern Session session;

#endif // MINORI_CORE_SESSION_H_
