#ifndef __gui__dialog__settings_h
#define __gui__dialog__settings_h
#include "core/anime.h"
#include <QDialog>
#include <QWidget>

class QLabel;
class QTabWidget;
class QStackedWidget;
class SideBar;

class SettingsPage : public QWidget {
		Q_OBJECT

	public:
		SettingsPage(QWidget* parent = nullptr, QString title = "");
		void SetTitle(QString title);
		virtual void SaveInfo() = 0;
		void AddTab(QWidget* tab, QString title = "");

	private:
		QLabel* page_title;
		QTabWidget* tab_widget;
};

class SettingsPageServices : public SettingsPage {
	public:
		SettingsPageServices(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateMainPage();
		QWidget* CreateAniListPage();
		QString username;
		Anime::Services service;
};

class SettingsPageApplication : public SettingsPage {
	public:
		SettingsPageApplication(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateAnimeListWidget();
		Anime::TitleLanguage language;
		bool display_aired_episodes;
		bool display_available_episodes;
		bool highlight_anime_if_available;
		bool highlighted_anime_above_others;
};

class SettingsDialog : public QDialog {
		Q_OBJECT

	public:
		SettingsDialog(QWidget* parent = nullptr);
		QWidget* CreateServicesMainPage(QWidget* parent);
		void OnOK();

	private:
		SideBar* sidebar;
		QStackedWidget* stacked;
};
#endif // __gui__dialog__settings_h
