#include "gui/pages/now_playing.h"
#include "core/anime_db.h"
#include "gui/widgets/anime_info.h"
#include "gui/widgets/text.h"
#include <QLabel>
#include <QStackedWidget>
#include <QVBoxLayout>
#include <QWidget>

/* This is here to make it easier to switch between the
   "sub-pages", i.e., not playing and playing.

   TODO: find a way to do this more efficiently */
namespace NowPlayingPages {

class Default : public QWidget {
		Q_OBJECT

	public:
		Default(QWidget* parent = nullptr);
};

class Playing : public QWidget {
		Q_OBJECT

	public:
		Playing(QWidget* parent = nullptr);
		void SetPlayingAnime(int id, const std::unordered_map<std::string, std::string>& info);
		int GetPlayingAnime();

	private:
		int _id = 0;
		int _episode = 0;
		std::unique_ptr<TextWidgets::Title> _title = nullptr;
		std::unique_ptr<AnimeInfoWidget> _info = nullptr;
};

Default::Default(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);
	layout->setContentsMargins(0, 0, 0, 0);

	TextWidgets::Title* title = new TextWidgets::Title(tr("Now Playing"), this);
	layout->addWidget(title);

	layout->addStretch();
}

Playing::Playing(QWidget* parent) : QWidget(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);

	_title.reset(new TextWidgets::Title("\n", this));
	layout->addWidget(_title.get());

	_info.reset(new AnimeInfoWidget(this));
	layout->addWidget(_info.get());

	layout->setContentsMargins(0, 0, 0, 0);
}

int Playing::GetPlayingAnime() {
	return _id;
}

void Playing::SetPlayingAnime(int id, const std::unordered_map<std::string, std::string>& info) {
	if (id == _id || id <= 0)
		return;
	if (Anime::db.items.find(id) != Anime::db.items.end()) {
		const Anime::Anime& anime = Anime::db.items[_id = id];
		_title->setText(anime.GetUserPreferredTitle());
		_info->SetAnime(anime);
	}
}

} // namespace NowPlayingPages

NowPlayingPage::NowPlayingPage(QWidget* parent) : QFrame(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);

	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Sunken);

	QPalette pal = QPalette();
	pal.setColor(QPalette::Window, pal.color(QPalette::Base));
	setPalette(pal);
	setAutoFillBackground(true);

	stack = new QStackedWidget(this);
	stack->addWidget(new NowPlayingPages::Default(stack));
	stack->addWidget(new NowPlayingPages::Playing(stack));
	layout->addWidget(stack);

	SetDefault();
}

void NowPlayingPage::SetDefault() {
	stack->setCurrentIndex(0);
}

int NowPlayingPage::GetPlayingId() {
	return reinterpret_cast<NowPlayingPages::Playing*>(stack->widget(1))->GetPlayingAnime();
}

void NowPlayingPage::SetPlaying(int id, const std::unordered_map<std::string, std::string>& info) {
	reinterpret_cast<NowPlayingPages::Playing*>(stack->widget(1))->SetPlayingAnime(id, info);
	stack->setCurrentIndex(1);
}

#include "gui/pages/moc_now_playing.cpp"
#include "now_playing.moc"
