//  CaseFolding-15.1.0.txt
//  Date: 2023-05-12, 21:53:10 GMT
//  © 2023 Unicode®, Inc.
//  Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
//  For terms of use, see https://www.unicode.org/terms_of_use.html

template <typename T2, typename T3>
struct unicode_casefolding
{
	static const T2 ucf_maxcodepoint = 0x1E921;
	static const T3 ucf_deltatablesize = 0x1A00;
	static const T2 rev_maxcodepoint = 0x1E943;
	static const T3 rev_indextablesize = 0x1C00;
	static const T3 rev_charsettablesize = 4312;	//  1 + 1427 * 2 + 1457
	static const T3 rev_maxset = 4;
	static const T2 eos = 0;

	static const T2 ucf_deltatable[];
	static const T3 ucf_segmenttable[];
	static const T3 rev_indextable[];
	static const T3 rev_segmenttable[];
	static const T2 rev_charsettable[];
};
template <typename T2, typename T3>
	const T2 unicode_casefolding<T2, T3>::ucf_maxcodepoint;
template <typename T2, typename T3>
	const T3 unicode_casefolding<T2, T3>::ucf_deltatablesize;
template <typename T2, typename T3>
	const T2 unicode_casefolding<T2, T3>::rev_maxcodepoint;
template <typename T2, typename T3>
	const T3 unicode_casefolding<T2, T3>::rev_indextablesize;
template <typename T2, typename T3>
	const T3 unicode_casefolding<T2, T3>::rev_charsettablesize;
template <typename T2, typename T3>
	const T3 unicode_casefolding<T2, T3>::rev_maxset;
template <typename T2, typename T3>
	const T2 unicode_casefolding<T2, T3>::eos;

template <typename T2, typename T3>
const T2 unicode_casefolding<T2, T3>::ucf_deltatable[] =
{
	//  For common (0)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+00xx (256)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 775, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 32, 32,  32, 32, 32, 0,  32, 32, 32, 32,  32, 32, 32, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+01xx (512)
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	0, 0, 1, 0,  1, 0, 1, 0,  0, 1, 0, 1,  0, 1, 0, 1,
	0, 1, 0, 1,  0, 1, 0, 1,  0, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  static_cast<T2>(-121), 1, 0, 1,  0, 1, 0, static_cast<T2>(-268),
	0, 210, 1, 0,  1, 0, 206, 1,  0, 205, 205, 1,  0, 0, 79, 202,
	203, 1, 0, 205,  207, 0, 211, 209,  1, 0, 0, 0,  211, 213, 0, 214,
	1, 0, 1, 0,  1, 0, 218, 1,  0, 218, 0, 0,  1, 0, 218, 1,
	0, 217, 217, 1,  0, 1, 0, 219,  1, 0, 0, 0,  1, 0, 0, 0,
	0, 0, 0, 0,  2, 1, 0, 2,  1, 0, 2, 1,  0, 1, 0, 1,
	0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	0, 2, 1, 0,  1, 0, static_cast<T2>(-97), static_cast<T2>(-56),  1, 0, 1, 0,  1, 0, 1, 0,

	//  For u+02xx (768)
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	static_cast<T2>(-130), 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  0, 0, 0, 0,  0, 0, 10795, 1,  0, static_cast<T2>(-163), 10792, 0,
	0, 1, 0, static_cast<T2>(-195),  69, 71, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+03xx (1024)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 116, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1, 0, 1, 0,  0, 0, 1, 0,  0, 0, 0, 0,  0, 0, 0, 116,
	0, 0, 0, 0,  0, 0, 38, 0,  37, 37, 37, 0,  64, 0, 63, 63,
	0, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 0, 32,  32, 32, 32, 32,  32, 32, 32, 32,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 1, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 8,
	static_cast<T2>(-30), static_cast<T2>(-25), 0, 0,  0, static_cast<T2>(-15), static_cast<T2>(-22), 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	static_cast<T2>(-54), static_cast<T2>(-48), 0, 0,  static_cast<T2>(-60), static_cast<T2>(-64), 0, 1,  0, static_cast<T2>(-7), 1, 0,  0, static_cast<T2>(-130), static_cast<T2>(-130), static_cast<T2>(-130),

	//  For u+04xx (1280)
	80, 80, 80, 80,  80, 80, 80, 80,  80, 80, 80, 80,  80, 80, 80, 80,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	15, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 1,  0, 1, 0, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,

	//  For u+05xx (1536)
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	0, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,
	48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,
	48, 48, 48, 48,  48, 48, 48, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+10xx (1792)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	7264, 7264, 7264, 7264,  7264, 7264, 7264, 7264,  7264, 7264, 7264, 7264,  7264, 7264, 7264, 7264,
	7264, 7264, 7264, 7264,  7264, 7264, 7264, 7264,  7264, 7264, 7264, 7264,  7264, 7264, 7264, 7264,
	7264, 7264, 7264, 7264,  7264, 7264, 0, 7264,  0, 0, 0, 0,  0, 7264, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+13xx (2048)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), 0, 0,

	//  For u+1Cxx (2304)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	static_cast<T2>(-6222), static_cast<T2>(-6221), static_cast<T2>(-6212), static_cast<T2>(-6210),  static_cast<T2>(-6210), static_cast<T2>(-6211), static_cast<T2>(-6204), static_cast<T2>(-6180),  35267, 0, 0, 0,  0, 0, 0, 0,
	static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),
	static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),
	static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),  static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008), 0,  0, static_cast<T2>(-3008), static_cast<T2>(-3008), static_cast<T2>(-3008),
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+1Exx (2560)
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 0, 0,  0, 0, 0, static_cast<T2>(-58),  0, 0, static_cast<T2>(-7615), 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,

	//  For u+1Fxx (2816)
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, static_cast<T2>(-8), 0, static_cast<T2>(-8),  0, static_cast<T2>(-8), 0, static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-8),
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-74), static_cast<T2>(-74),  static_cast<T2>(-9), 0, static_cast<T2>(-7173), 0,
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-86), static_cast<T2>(-86), static_cast<T2>(-86), static_cast<T2>(-86),  static_cast<T2>(-9), 0, 0, 0,
	0, 0, 0, static_cast<T2>(-7235),  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-100), static_cast<T2>(-100),  0, 0, 0, 0,
	0, 0, 0, static_cast<T2>(-7219),  0, 0, 0, 0,  static_cast<T2>(-8), static_cast<T2>(-8), static_cast<T2>(-112), static_cast<T2>(-112),  static_cast<T2>(-7), 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  static_cast<T2>(-128), static_cast<T2>(-128), static_cast<T2>(-126), static_cast<T2>(-126),  static_cast<T2>(-9), 0, 0, 0,

	//  For u+21xx (3072)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, static_cast<T2>(-7517), 0,  0, 0, static_cast<T2>(-8383), static_cast<T2>(-8262),  0, 0, 0, 0,
	0, 0, 28, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	16, 16, 16, 16,  16, 16, 16, 16,  16, 16, 16, 16,  16, 16, 16, 16,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 1,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+24xx (3328)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 26, 26,  26, 26, 26, 26,  26, 26, 26, 26,
	26, 26, 26, 26,  26, 26, 26, 26,  26, 26, 26, 26,  26, 26, 26, 26,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+2Cxx (3584)
	48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,
	48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,
	48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,  48, 48, 48, 48,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1, 0, static_cast<T2>(-10743), static_cast<T2>(-3814),  static_cast<T2>(-10727), 0, 0, 1,  0, 1, 0, 1,  0, static_cast<T2>(-10780), static_cast<T2>(-10749), static_cast<T2>(-10783),
	static_cast<T2>(-10782), 0, 1, 0,  0, 1, 0, 0,  0, 0, 0, 0,  0, 0, static_cast<T2>(-10815), static_cast<T2>(-10815),
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 1, 0, 0,
	0, 0, 1, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+A6xx (3840)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+A7xx (4096)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	0, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 1,  0, static_cast<T2>(-35332), 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  0, 0, 0, 1,  0, static_cast<T2>(-42280), 0, 0,
	1, 0, 1, 0,  0, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  1, 0, 1, 0,  1, 0, static_cast<T2>(-42308), static_cast<T2>(-42319),  static_cast<T2>(-42315), static_cast<T2>(-42305), static_cast<T2>(-42308), 0,
	static_cast<T2>(-42258), static_cast<T2>(-42282), static_cast<T2>(-42261), 928,  1, 0, 1, 0,  1, 0, 1, 0,  1, 0, 1, 0,
	1, 0, 1, 0,  static_cast<T2>(-48), static_cast<T2>(-42307), static_cast<T2>(-35384), 1,  0, 1, 0, 0,  0, 0, 0, 0,
	1, 0, 0, 0,  0, 0, 1, 0,  1, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+ABxx (4352)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),
	static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),
	static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),
	static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),
	static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),  static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864), static_cast<T2>(-38864),
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+FBxx (4608)
	0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+FFxx (4864)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+104xx (5120)
	40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,
	40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,
	40, 40, 40, 40,  40, 40, 40, 40,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,
	40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,  40, 40, 40, 40,
	40, 40, 40, 40,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+105xx (5376)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	39, 39, 39, 39,  39, 39, 39, 39,  39, 39, 39, 0,  39, 39, 39, 39,
	39, 39, 39, 39,  39, 39, 39, 39,  39, 39, 39, 0,  39, 39, 39, 39,
	39, 39, 39, 0,  39, 39, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+10Cxx (5632)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	64, 64, 64, 64,  64, 64, 64, 64,  64, 64, 64, 64,  64, 64, 64, 64,
	64, 64, 64, 64,  64, 64, 64, 64,  64, 64, 64, 64,  64, 64, 64, 64,
	64, 64, 64, 64,  64, 64, 64, 64,  64, 64, 64, 64,  64, 64, 64, 64,
	64, 64, 64, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+118xx (5888)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+16Exx (6144)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,  32, 32, 32, 32,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+1E9xx (6400)
	34, 34, 34, 34,  34, 34, 34, 34,  34, 34, 34, 34,  34, 34, 34, 34,
	34, 34, 34, 34,  34, 34, 34, 34,  34, 34, 34, 34,  34, 34, 34, 34,
	34, 34, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
};

template <typename T2, typename T3>
const T3 unicode_casefolding<T2, T3>::ucf_segmenttable[] =
{
	256, 512, 768, 1024,  1280, 1536, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1792, 0, 0, 2048,  0, 0, 0, 0,  0, 0, 0, 0,  2304, 0, 2560, 2816,
	0, 3072, 0, 0,  3328, 0, 0, 0,  0, 0, 0, 0,  3584, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 3840, 4096,  0, 0, 0, 4352,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 4608,  0, 0, 0, 4864,
	0, 0, 0, 0,  5120, 5376, 0, 0,  0, 0, 0, 0,  5632, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  5888, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 6144, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 6400
};

template <typename T2, typename T3>
const T3 unicode_casefolding<T2, T3>::rev_indextable[] =
{
	//  For common (0)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+00xx (256)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 1, 4, 7,  10, 13, 16, 19,  22, 25, 28, 31,  35, 38, 41, 44,
	47, 50, 53, 56,  60, 63, 66, 69,  72, 75, 78, 0,  0, 0, 0, 0,
	0, 1, 4, 7,  10, 13, 16, 19,  22, 25, 28, 31,  35, 38, 41, 44,
	47, 50, 53, 56,  60, 63, 66, 69,  72, 75, 78, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 81, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	85, 88, 91, 94,  97, 100, 104, 107,  110, 113, 116, 119,  122, 125, 128, 131,
	134, 137, 140, 143,  146, 149, 152, 0,  155, 158, 161, 164,  167, 170, 173, 1924,
	85, 88, 91, 94,  97, 100, 104, 107,  110, 113, 116, 119,  122, 125, 128, 131,
	134, 137, 140, 143,  146, 149, 152, 0,  155, 158, 161, 164,  167, 170, 173, 350,

	//  For u+21xx (512)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 785, 0,  0, 0, 31, 100,  0, 0, 0, 0,
	0, 0, 2365, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 2365, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	2368, 2371, 2374, 2377,  2380, 2383, 2386, 2389,  2392, 2395, 2398, 2401,  2404, 2407, 2410, 2413,
	2368, 2371, 2374, 2377,  2380, 2383, 2386, 2389,  2392, 2395, 2398, 2401,  2404, 2407, 2410, 2413,
	0, 0, 0, 2416,  2416, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+01xx (768)
	176, 176, 179, 179,  182, 182, 185, 185,  188, 188, 191, 191,  194, 194, 197, 197,
	200, 200, 203, 203,  206, 206, 209, 209,  212, 212, 215, 215,  218, 218, 221, 221,
	224, 224, 227, 227,  230, 230, 233, 233,  236, 236, 239, 239,  242, 242, 245, 245,
	0, 0, 248, 248,  251, 251, 254, 254,  0, 257, 257, 260,  260, 263, 263, 266,
	266, 269, 269, 272,  272, 275, 275, 278,  278, 0, 281, 281,  284, 284, 287, 287,
	290, 290, 293, 293,  296, 296, 299, 299,  302, 302, 305, 305,  308, 308, 311, 311,
	314, 314, 317, 317,  320, 320, 323, 323,  326, 326, 329, 329,  332, 332, 335, 335,
	338, 338, 341, 341,  344, 344, 347, 347,  350, 353, 353, 356,  356, 359, 359, 56,
	651, 362, 365, 365,  368, 368, 371, 374,  374, 377, 380, 383,  383, 0, 386, 389,
	392, 395, 395, 398,  401, 540, 404, 407,  410, 410, 642, 0,  413, 416, 606, 419,
	422, 422, 425, 425,  428, 428, 431, 434,  434, 437, 0, 0,  440, 440, 443, 446,
	446, 449, 452, 455,  455, 458, 458, 461,  464, 464, 0, 0,  467, 467, 0, 543,
	0, 0, 0, 0,  470, 470, 470, 474,  474, 474, 478, 478,  478, 482, 482, 485,
	485, 488, 488, 491,  491, 494, 494, 497,  497, 500, 500, 503,  503, 386, 506, 506,
	509, 509, 512, 512,  515, 515, 518, 518,  521, 521, 524, 524,  527, 527, 530, 530,
	0, 533, 533, 533,  537, 537, 540, 543,  546, 546, 549, 549,  552, 552, 555, 555,

	//  For u+03xx (1024)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 675, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	680, 680, 683, 683,  0, 0, 686, 686,  0, 0, 0, 843,  846, 849, 0, 689,
	0, 0, 0, 0,  0, 0, 692, 0,  695, 698, 701, 0,  704, 0, 707, 710,
	2317, 713, 716, 720,  723, 726, 730, 733,  736, 675, 741, 745,  81, 748, 751, 754,
	757, 761, 0, 765,  769, 772, 775, 779,  782, 785, 789, 792,  692, 695, 698, 701,
	2332, 713, 716, 720,  723, 726, 730, 733,  736, 675, 741, 745,  81, 748, 751, 754,
	757, 761, 765, 765,  769, 772, 775, 779,  782, 785, 789, 792,  704, 707, 710, 795,
	716, 736, 0, 0,  0, 775, 757, 795,  798, 798, 801, 801,  804, 804, 807, 807,
	810, 810, 813, 813,  816, 816, 819, 819,  822, 822, 825, 825,  828, 828, 831, 831,
	741, 761, 837, 689,  736, 726, 0, 834,  834, 837, 840, 840,  0, 843, 846, 849,

	//  For u+02xx (1280)
	558, 558, 561, 561,  564, 564, 567, 567,  570, 570, 573, 573,  576, 576, 579, 579,
	582, 582, 585, 585,  588, 588, 591, 591,  594, 594, 597, 597,  600, 600, 603, 603,
	606, 0, 609, 609,  612, 612, 615, 615,  618, 618, 621, 621,  624, 624, 627, 627,
	630, 630, 633, 633,  0, 0, 0, 0,  0, 0, 636, 639,  639, 642, 645, 2680,
	2683, 648, 648, 651,  654, 657, 660, 660,  663, 663, 666, 666,  669, 669, 672, 672,
	2668, 2662, 2671, 362,  371, 0, 377, 380,  0, 389, 0, 392,  3136, 0, 0, 0,
	398, 3139, 0, 401,  0, 3094, 3133, 0,  407, 404, 3145, 2644,  3142, 0, 0, 413,
	0, 2665, 416, 0,  0, 419, 0, 0,  0, 0, 0, 0,  0, 2650, 0, 0,
	431, 0, 3187, 437,  0, 0, 0, 3151,  443, 654, 449, 452,  657, 0, 0, 0,
	0, 0, 461, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 3154, 3148, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+2Cxx (1536)
	2497, 2500, 2503, 2506,  2509, 2512, 2515, 2518,  2521, 2524, 2527, 2530,  2533, 2536, 2539, 2542,
	2545, 2548, 2551, 2554,  2557, 2560, 2563, 2566,  2569, 2572, 2575, 2578,  2581, 2584, 2587, 2590,
	2593, 2596, 2599, 2602,  2605, 2608, 2611, 2614,  2617, 2620, 2623, 2626,  2629, 2632, 2635, 2638,
	2497, 2500, 2503, 2506,  2509, 2512, 2515, 2518,  2521, 2524, 2527, 2530,  2533, 2536, 2539, 2542,
	2545, 2548, 2551, 2554,  2557, 2560, 2563, 2566,  2569, 2572, 2575, 2578,  2581, 2584, 2587, 2590,
	2593, 2596, 2599, 2602,  2605, 2608, 2611, 2614,  2617, 2620, 2623, 2626,  2629, 2632, 2635, 2638,
	2641, 2641, 2644, 2647,  2650, 636, 645, 2653,  2653, 2656, 2656, 2659,  2659, 2662, 2665, 2668,
	2671, 0, 2674, 2674,  0, 2677, 2677, 0,  0, 0, 0, 0,  0, 0, 2680, 2683,
	2686, 2686, 2689, 2689,  2692, 2692, 2695, 2695,  2698, 2698, 2701, 2701,  2704, 2704, 2707, 2707,
	2710, 2710, 2713, 2713,  2716, 2716, 2719, 2719,  2722, 2722, 2725, 2725,  2728, 2728, 2731, 2731,
	2734, 2734, 2737, 2737,  2740, 2740, 2743, 2743,  2746, 2746, 2749, 2749,  2752, 2752, 2755, 2755,
	2758, 2758, 2761, 2761,  2764, 2764, 2767, 2767,  2770, 2770, 2773, 2773,  2776, 2776, 2779, 2779,
	2782, 2782, 2785, 2785,  2788, 2788, 2791, 2791,  2794, 2794, 2797, 2797,  2800, 2800, 2803, 2803,
	2806, 2806, 2809, 2809,  2812, 2812, 2815, 2815,  2818, 2818, 2821, 2821,  2824, 2824, 2827, 2827,
	2830, 2830, 2833, 2833,  0, 0, 0, 0,  0, 0, 0, 2836,  2836, 2839, 2839, 0,
	0, 0, 2842, 2842,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+1Fxx (1792)
	2071, 2074, 2077, 2080,  2083, 2086, 2089, 2092,  2071, 2074, 2077, 2080,  2083, 2086, 2089, 2092,
	2095, 2098, 2101, 2104,  2107, 2110, 0, 0,  2095, 2098, 2101, 2104,  2107, 2110, 0, 0,
	2113, 2116, 2119, 2122,  2125, 2128, 2131, 2134,  2113, 2116, 2119, 2122,  2125, 2128, 2131, 2134,
	2137, 2140, 2143, 2146,  2149, 2152, 2155, 2158,  2137, 2140, 2143, 2146,  2149, 2152, 2155, 2158,
	2161, 2164, 2167, 2170,  2173, 2176, 0, 0,  2161, 2164, 2167, 2170,  2173, 2176, 0, 0,
	0, 2179, 0, 2182,  0, 2185, 0, 2188,  0, 2179, 0, 2182,  0, 2185, 0, 2188,
	2191, 2194, 2197, 2200,  2203, 2206, 2209, 2212,  2191, 2194, 2197, 2200,  2203, 2206, 2209, 2212,
	2293, 2296, 2302, 2305,  2308, 2311, 2326, 2329,  2350, 2353, 2341, 2344,  2356, 2359, 0, 0,
	2215, 2218, 2221, 2224,  2227, 2230, 2233, 2236,  2215, 2218, 2221, 2224,  2227, 2230, 2233, 2236,
	2239, 2242, 2245, 2248,  2251, 2254, 2257, 2260,  2239, 2242, 2245, 2248,  2251, 2254, 2257, 2260,
	2263, 2266, 2269, 2272,  2275, 2278, 2281, 2284,  2263, 2266, 2269, 2272,  2275, 2278, 2281, 2284,
	2287, 2290, 0, 2299,  0, 0, 0, 0,  2287, 2290, 2293, 2296,  2299, 0, 675, 0,
	0, 0, 0, 2314,  0, 0, 0, 0,  2302, 2305, 2308, 2311,  2314, 0, 0, 0,
	2320, 2323, 0, 2317,  0, 0, 0, 0,  2320, 2323, 2326, 2329,  0, 0, 0, 0,
	2335, 2338, 0, 2332,  0, 2347, 0, 0,  2335, 2338, 2341, 2344,  2347, 0, 0, 0,
	0, 0, 0, 2362,  0, 0, 0, 0,  2350, 2353, 2356, 2359,  2362, 0, 0, 0,

	//  For u+04xx (2048)
	852, 855, 858, 861,  864, 867, 870, 873,  876, 879, 882, 885,  888, 891, 894, 897,
	900, 903, 906, 910,  913, 917, 920, 923,  926, 929, 932, 935,  938, 941, 944, 948,
	951, 954, 958, 963,  966, 969, 972, 975,  978, 981, 984, 988,  991, 994, 997, 1000,
	900, 903, 906, 910,  913, 917, 920, 923,  926, 929, 932, 935,  938, 941, 944, 948,
	951, 954, 958, 963,  966, 969, 972, 975,  978, 981, 984, 988,  991, 994, 997, 1000,
	852, 855, 858, 861,  864, 867, 870, 873,  876, 879, 882, 885,  888, 891, 894, 897,
	1003, 1003, 1006, 1006,  1010, 1010, 1013, 1013,  1016, 1016, 1019, 1019,  1022, 1022, 1025, 1025,
	1028, 1028, 1031, 1031,  1034, 1034, 1037, 1037,  1040, 1040, 1043, 1043,  1046, 1046, 1049, 1049,
	1052, 1052, 0, 0,  0, 0, 0, 0,  0, 0, 1055, 1055,  1058, 1058, 1061, 1061,
	1064, 1064, 1067, 1067,  1070, 1070, 1073, 1073,  1076, 1076, 1079, 1079,  1082, 1082, 1085, 1085,
	1088, 1088, 1091, 1091,  1094, 1094, 1097, 1097,  1100, 1100, 1103, 1103,  1106, 1106, 1109, 1109,
	1112, 1112, 1115, 1115,  1118, 1118, 1121, 1121,  1124, 1124, 1127, 1127,  1130, 1130, 1133, 1133,
	1136, 1139, 1139, 1142,  1142, 1145, 1145, 1148,  1148, 1151, 1151, 1154,  1154, 1157, 1157, 1136,
	1160, 1160, 1163, 1163,  1166, 1166, 1169, 1169,  1172, 1172, 1175, 1175,  1178, 1178, 1181, 1181,
	1184, 1184, 1187, 1187,  1190, 1190, 1193, 1193,  1196, 1196, 1199, 1199,  1202, 1202, 1205, 1205,
	1208, 1208, 1211, 1211,  1214, 1214, 1217, 1217,  1220, 1220, 1223, 1223,  1226, 1226, 1229, 1229,

	//  For u+1Cxx (2304)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	906, 913, 944, 954,  958, 958, 984, 1006,  1556, 0, 0, 0,  0, 0, 0, 0,
	1560, 1563, 1566, 1569,  1572, 1575, 1578, 1581,  1584, 1587, 1590, 1593,  1596, 1599, 1602, 1605,
	1608, 1611, 1614, 1617,  1620, 1623, 1626, 1629,  1632, 1635, 1638, 1641,  1644, 1647, 1650, 1653,
	1656, 1659, 1662, 1665,  1668, 1671, 1674, 1677,  1680, 1683, 1686, 0,  0, 1689, 1692, 1695,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+05xx (2560)
	1232, 1232, 1235, 1235,  1238, 1238, 1241, 1241,  1244, 1244, 1247, 1247,  1250, 1250, 1253, 1253,
	1256, 1256, 1259, 1259,  1262, 1262, 1265, 1265,  1268, 1268, 1271, 1271,  1274, 1274, 1277, 1277,
	1280, 1280, 1283, 1283,  1286, 1286, 1289, 1289,  1292, 1292, 1295, 1295,  1298, 1298, 1301, 1301,
	0, 1304, 1307, 1310,  1313, 1316, 1319, 1322,  1325, 1328, 1331, 1334,  1337, 1340, 1343, 1346,
	1349, 1352, 1355, 1358,  1361, 1364, 1367, 1370,  1373, 1376, 1379, 1382,  1385, 1388, 1391, 1394,
	1397, 1400, 1403, 1406,  1409, 1412, 1415, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 1304, 1307, 1310,  1313, 1316, 1319, 1322,  1325, 1328, 1331, 1334,  1337, 1340, 1343, 1346,
	1349, 1352, 1355, 1358,  1361, 1364, 1367, 1370,  1373, 1376, 1379, 1382,  1385, 1388, 1391, 1394,
	1397, 1400, 1403, 1406,  1409, 1412, 1415, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+2Dxx (2816)
	1418, 1421, 1424, 1427,  1430, 1433, 1436, 1439,  1442, 1445, 1448, 1451,  1454, 1457, 1460, 1463,
	1466, 1469, 1472, 1475,  1478, 1481, 1484, 1487,  1490, 1493, 1496, 1499,  1502, 1505, 1508, 1511,
	1514, 1517, 1520, 1523,  1526, 1529, 0, 1532,  0, 0, 0, 0,  0, 1535, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+10xx (3072)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	1418, 1421, 1424, 1427,  1430, 1433, 1436, 1439,  1442, 1445, 1448, 1451,  1454, 1457, 1460, 1463,
	1466, 1469, 1472, 1475,  1478, 1481, 1484, 1487,  1490, 1493, 1496, 1499,  1502, 1505, 1508, 1511,
	1514, 1517, 1520, 1523,  1526, 1529, 0, 1532,  0, 0, 0, 0,  0, 1535, 0, 0,
	1560, 1563, 1566, 1569,  1572, 1575, 1578, 1581,  1584, 1587, 1590, 1593,  1596, 1599, 1602, 1605,
	1608, 1611, 1614, 1617,  1620, 1623, 1626, 1629,  1632, 1635, 1638, 1641,  1644, 1647, 1650, 1653,
	1656, 1659, 1662, 1665,  1668, 1671, 1674, 1677,  1680, 1683, 1686, 0,  0, 1689, 1692, 1695,

	//  For u+13xx (3328)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3211, 3214, 3217, 3220,  3223, 3226, 3229, 3232,  3235, 3238, 3241, 3244,  3247, 3250, 3253, 3256,
	3259, 3262, 3265, 3268,  3271, 3274, 3277, 3280,  3283, 3286, 3289, 3292,  3295, 3298, 3301, 3304,
	3307, 3310, 3313, 3316,  3319, 3322, 3325, 3328,  3331, 3334, 3337, 3340,  3343, 3346, 3349, 3352,
	3355, 3358, 3361, 3364,  3367, 3370, 3373, 3376,  3379, 3382, 3385, 3388,  3391, 3394, 3397, 3400,
	3403, 3406, 3409, 3412,  3415, 3418, 3421, 3424,  3427, 3430, 3433, 3436,  3439, 3442, 3445, 3448,
	1538, 1541, 1544, 1547,  1550, 1553, 0, 0,  1538, 1541, 1544, 1547,  1550, 1553, 0, 0,

	//  For u+A6xx (3584)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	2845, 2845, 2848, 2848,  2851, 2851, 2854, 2854,  2857, 2857, 1556, 1556,  2860, 2860, 2863, 2863,
	2866, 2866, 2869, 2869,  2872, 2872, 2875, 2875,  2878, 2878, 2881, 2881,  2884, 2884, 2887, 2887,
	2890, 2890, 2893, 2893,  2896, 2896, 2899, 2899,  2902, 2902, 2905, 2905,  2908, 2908, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	2911, 2911, 2914, 2914,  2917, 2917, 2920, 2920,  2923, 2923, 2926, 2926,  2929, 2929, 2932, 2932,
	2935, 2935, 2938, 2938,  2941, 2941, 2944, 2944,  2947, 2947, 2950, 2950,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+1Exx (3840)
	1698, 1698, 1701, 1701,  1704, 1704, 1707, 1707,  1710, 1710, 1713, 1713,  1716, 1716, 1719, 1719,
	1722, 1722, 1725, 1725,  1728, 1728, 1731, 1731,  1734, 1734, 1737, 1737,  1740, 1740, 1743, 1743,
	1746, 1746, 1749, 1749,  1752, 1752, 1755, 1755,  1758, 1758, 1761, 1761,  1764, 1764, 1767, 1767,
	1770, 1770, 1773, 1773,  1776, 1776, 1779, 1779,  1782, 1782, 1785, 1785,  1788, 1788, 1791, 1791,
	1794, 1794, 1797, 1797,  1800, 1800, 1803, 1803,  1806, 1806, 1809, 1809,  1812, 1812, 1815, 1815,
	1818, 1818, 1821, 1821,  1824, 1824, 1827, 1827,  1830, 1830, 1833, 1833,  1836, 1836, 1839, 1839,
	1842, 1842, 1846, 1846,  1849, 1849, 1852, 1852,  1855, 1855, 1858, 1858,  1861, 1861, 1864, 1864,
	1867, 1867, 1870, 1870,  1873, 1873, 1876, 1876,  1879, 1879, 1882, 1882,  1885, 1885, 1888, 1888,
	1891, 1891, 1894, 1894,  1897, 1897, 1900, 1900,  1903, 1903, 1906, 1906,  1909, 1909, 1912, 1912,
	1915, 1915, 1918, 1918,  1921, 1921, 0, 0,  0, 0, 0, 1842,  0, 0, 1924, 0,
	1927, 1927, 1930, 1930,  1933, 1933, 1936, 1936,  1939, 1939, 1942, 1942,  1945, 1945, 1948, 1948,
	1951, 1951, 1954, 1954,  1957, 1957, 1960, 1960,  1963, 1963, 1966, 1966,  1969, 1969, 1972, 1972,
	1975, 1975, 1978, 1978,  1981, 1981, 1984, 1984,  1987, 1987, 1990, 1990,  1993, 1993, 1996, 1996,
	1999, 1999, 2002, 2002,  2005, 2005, 2008, 2008,  2011, 2011, 2014, 2014,  2017, 2017, 2020, 2020,
	2023, 2023, 2026, 2026,  2029, 2029, 2032, 2032,  2035, 2035, 2038, 2038,  2041, 2041, 2044, 2044,
	2047, 2047, 2050, 2050,  2053, 2053, 2056, 2056,  2059, 2059, 2062, 2062,  2065, 2065, 2068, 2068,

	//  For u+24xx (4096)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 2419, 2422,  2425, 2428, 2431, 2434,  2437, 2440, 2443, 2446,
	2449, 2452, 2455, 2458,  2461, 2464, 2467, 2470,  2473, 2476, 2479, 2482,  2485, 2488, 2491, 2494,
	2419, 2422, 2425, 2428,  2431, 2434, 2437, 2440,  2443, 2446, 2449, 2452,  2455, 2458, 2461, 2464,
	2467, 2470, 2473, 2476,  2479, 2482, 2485, 2488,  2491, 2494, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+1Dxx (4352)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 3073, 0, 0,  0, 2647, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 3190, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+A7xx (4608)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 2953, 2953,  2956, 2956, 2959, 2959,  2962, 2962, 2965, 2965,  2968, 2968, 2971, 2971,
	0, 0, 2974, 2974,  2977, 2977, 2980, 2980,  2983, 2983, 2986, 2986,  2989, 2989, 2992, 2992,
	2995, 2995, 2998, 2998,  3001, 3001, 3004, 3004,  3007, 3007, 3010, 3010,  3013, 3013, 3016, 3016,
	3019, 3019, 3022, 3022,  3025, 3025, 3028, 3028,  3031, 3031, 3034, 3034,  3037, 3037, 3040, 3040,
	3043, 3043, 3046, 3046,  3049, 3049, 3052, 3052,  3055, 3055, 3058, 3058,  3061, 3061, 3064, 3064,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 3067, 3067, 3070,  3070, 3073, 3076, 3076,
	3079, 3079, 3082, 3082,  3085, 3085, 3088, 3088,  0, 0, 0, 3091,  3091, 3094, 0, 0,
	3097, 3097, 3100, 3100,  3184, 0, 3103, 3103,  3106, 3106, 3109, 3109,  3112, 3112, 3115, 3115,
	3118, 3118, 3121, 3121,  3124, 3124, 3127, 3127,  3130, 3130, 3133, 3136,  3139, 3142, 3145, 0,
	3148, 3151, 3154, 3157,  3160, 3160, 3163, 3163,  3166, 3166, 3169, 3169,  3172, 3172, 3175, 3175,
	3178, 3178, 3181, 3181,  3184, 3187, 3190, 3193,  3193, 3196, 3196, 0,  0, 0, 0, 0,
	3199, 3199, 0, 0,  0, 0, 3202, 3202,  3205, 3205, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 3208, 3208, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+ABxx (4864)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 3157,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3211, 3214, 3217, 3220,  3223, 3226, 3229, 3232,  3235, 3238, 3241, 3244,  3247, 3250, 3253, 3256,
	3259, 3262, 3265, 3268,  3271, 3274, 3277, 3280,  3283, 3286, 3289, 3292,  3295, 3298, 3301, 3304,
	3307, 3310, 3313, 3316,  3319, 3322, 3325, 3328,  3331, 3334, 3337, 3340,  3343, 3346, 3349, 3352,
	3355, 3358, 3361, 3364,  3367, 3370, 3373, 3376,  3379, 3382, 3385, 3388,  3391, 3394, 3397, 3400,
	3403, 3406, 3409, 3412,  3415, 3418, 3421, 3424,  3427, 3430, 3433, 3436,  3439, 3442, 3445, 3448,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+FBxx (5120)
	0, 0, 0, 0,  0, 3451, 3451, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+FFxx (5376)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 3454, 3457, 3460,  3463, 3466, 3469, 3472,  3475, 3478, 3481, 3484,  3487, 3490, 3493, 3496,
	3499, 3502, 3505, 3508,  3511, 3514, 3517, 3520,  3523, 3526, 3529, 0,  0, 0, 0, 0,
	0, 3454, 3457, 3460,  3463, 3466, 3469, 3472,  3475, 3478, 3481, 3484,  3487, 3490, 3493, 3496,
	3499, 3502, 3505, 3508,  3511, 3514, 3517, 3520,  3523, 3526, 3529, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+104xx (5632)
	3532, 3535, 3538, 3541,  3544, 3547, 3550, 3553,  3556, 3559, 3562, 3565,  3568, 3571, 3574, 3577,
	3580, 3583, 3586, 3589,  3592, 3595, 3598, 3601,  3604, 3607, 3610, 3613,  3616, 3619, 3622, 3625,
	3628, 3631, 3634, 3637,  3640, 3643, 3646, 3649,  3532, 3535, 3538, 3541,  3544, 3547, 3550, 3553,
	3556, 3559, 3562, 3565,  3568, 3571, 3574, 3577,  3580, 3583, 3586, 3589,  3592, 3595, 3598, 3601,
	3604, 3607, 3610, 3613,  3616, 3619, 3622, 3625,  3628, 3631, 3634, 3637,  3640, 3643, 3646, 3649,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3652, 3655, 3658, 3661,  3664, 3667, 3670, 3673,  3676, 3679, 3682, 3685,  3688, 3691, 3694, 3697,
	3700, 3703, 3706, 3709,  3712, 3715, 3718, 3721,  3724, 3727, 3730, 3733,  3736, 3739, 3742, 3745,
	3748, 3751, 3754, 3757,  0, 0, 0, 0,  3652, 3655, 3658, 3661,  3664, 3667, 3670, 3673,
	3676, 3679, 3682, 3685,  3688, 3691, 3694, 3697,  3700, 3703, 3706, 3709,  3712, 3715, 3718, 3721,
	3724, 3727, 3730, 3733,  3736, 3739, 3742, 3745,  3748, 3751, 3754, 3757,  0, 0, 0, 0,

	//  For u+105xx (5888)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3760, 3763, 3766, 3769,  3772, 3775, 3778, 3781,  3784, 3787, 3790, 0,  3793, 3796, 3799, 3802,
	3805, 3808, 3811, 3814,  3817, 3820, 3823, 3826,  3829, 3832, 3835, 0,  3838, 3841, 3844, 3847,
	3850, 3853, 3856, 0,  3859, 3862, 0, 3760,  3763, 3766, 3769, 3772,  3775, 3778, 3781, 3784,
	3787, 3790, 0, 3793,  3796, 3799, 3802, 3805,  3808, 3811, 3814, 3817,  3820, 3823, 3826, 3829,
	3832, 3835, 0, 3838,  3841, 3844, 3847, 3850,  3853, 3856, 0, 3859,  3862, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+10Cxx (6144)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3865, 3868, 3871, 3874,  3877, 3880, 3883, 3886,  3889, 3892, 3895, 3898,  3901, 3904, 3907, 3910,
	3913, 3916, 3919, 3922,  3925, 3928, 3931, 3934,  3937, 3940, 3943, 3946,  3949, 3952, 3955, 3958,
	3961, 3964, 3967, 3970,  3973, 3976, 3979, 3982,  3985, 3988, 3991, 3994,  3997, 4000, 4003, 4006,
	4009, 4012, 4015, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3865, 3868, 3871, 3874,  3877, 3880, 3883, 3886,  3889, 3892, 3895, 3898,  3901, 3904, 3907, 3910,
	3913, 3916, 3919, 3922,  3925, 3928, 3931, 3934,  3937, 3940, 3943, 3946,  3949, 3952, 3955, 3958,
	3961, 3964, 3967, 3970,  3973, 3976, 3979, 3982,  3985, 3988, 3991, 3994,  3997, 4000, 4003, 4006,
	4009, 4012, 4015, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+118xx (6400)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	4018, 4021, 4024, 4027,  4030, 4033, 4036, 4039,  4042, 4045, 4048, 4051,  4054, 4057, 4060, 4063,
	4066, 4069, 4072, 4075,  4078, 4081, 4084, 4087,  4090, 4093, 4096, 4099,  4102, 4105, 4108, 4111,
	4018, 4021, 4024, 4027,  4030, 4033, 4036, 4039,  4042, 4045, 4048, 4051,  4054, 4057, 4060, 4063,
	4066, 4069, 4072, 4075,  4078, 4081, 4084, 4087,  4090, 4093, 4096, 4099,  4102, 4105, 4108, 4111,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+16Exx (6656)
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	4114, 4117, 4120, 4123,  4126, 4129, 4132, 4135,  4138, 4141, 4144, 4147,  4150, 4153, 4156, 4159,
	4162, 4165, 4168, 4171,  4174, 4177, 4180, 4183,  4186, 4189, 4192, 4195,  4198, 4201, 4204, 4207,
	4114, 4117, 4120, 4123,  4126, 4129, 4132, 4135,  4138, 4141, 4144, 4147,  4150, 4153, 4156, 4159,
	4162, 4165, 4168, 4171,  4174, 4177, 4180, 4183,  4186, 4189, 4192, 4195,  4198, 4201, 4204, 4207,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

	//  For u+1E9xx (6912)
	4210, 4213, 4216, 4219,  4222, 4225, 4228, 4231,  4234, 4237, 4240, 4243,  4246, 4249, 4252, 4255,
	4258, 4261, 4264, 4267,  4270, 4273, 4276, 4279,  4282, 4285, 4288, 4291,  4294, 4297, 4300, 4303,
	4306, 4309, 4210, 4213,  4216, 4219, 4222, 4225,  4228, 4231, 4234, 4237,  4240, 4243, 4246, 4249,
	4252, 4255, 4258, 4261,  4264, 4267, 4270, 4273,  4276, 4279, 4282, 4285,  4288, 4291, 4294, 4297,
	4300, 4303, 4306, 4309,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
};

template <typename T2, typename T3>
const T3 unicode_casefolding<T2, T3>::rev_segmenttable[] =
{
	256, 768, 1280, 1024,  2048, 2560, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	3072, 0, 0, 3328,  0, 0, 0, 0,  0, 0, 0, 0,  2304, 4352, 3840, 1792,
	0, 512, 0, 0,  4096, 0, 0, 0,  0, 0, 0, 0,  1536, 2816, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 3584, 4608,  0, 0, 0, 4864,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 5120,  0, 0, 0, 5376,
	0, 0, 0, 0,  5632, 5888, 0, 0,  0, 0, 0, 0,  6144, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  6400, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 6656, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
	0, 0, 0, 0,  0, 0, 0, 0,  0, 6912
};

template <typename T2, typename T3>
const T2 unicode_casefolding<T2, T3>::rev_charsettable[] =
{
	eos,	//  0
	0x0061, 0x0041, eos,
	0x0062, 0x0042, eos,
	0x0063, 0x0043, eos,
	0x0064, 0x0044, eos,	//  10
	0x0065, 0x0045, eos,
	0x0066, 0x0046, eos,
	0x0067, 0x0047, eos,
	0x0068, 0x0048, eos,	//  22
	0x0069, 0x0049, eos,
	0x006A, 0x004A, eos,
	0x006B, 0x004B, 0x212A, eos,	//  31
	0x006C, 0x004C, eos,
	0x006D, 0x004D, eos,
	0x006E, 0x004E, eos,	//  41
	0x006F, 0x004F, eos,
	0x0070, 0x0050, eos,
	0x0071, 0x0051, eos,	//  50
	0x0072, 0x0052, eos,
	0x0073, 0x0053, 0x017F, eos,
	0x0074, 0x0054, eos,	//  60
	0x0075, 0x0055, eos,
	0x0076, 0x0056, eos,
	0x0077, 0x0057, eos,
	0x0078, 0x0058, eos,	//  72
	0x0079, 0x0059, eos,
	0x007A, 0x005A, eos,
	0x03BC, 0x00B5, 0x039C, eos,	//  81
	0x00E0, 0x00C0, eos,
	0x00E1, 0x00C1, eos,
	0x00E2, 0x00C2, eos,	//  91
	0x00E3, 0x00C3, eos,
	0x00E4, 0x00C4, eos,
	0x00E5, 0x00C5, 0x212B, eos,	//  100
	0x00E6, 0x00C6, eos,
	0x00E7, 0x00C7, eos,
	0x00E8, 0x00C8, eos,	//  110
	0x00E9, 0x00C9, eos,
	0x00EA, 0x00CA, eos,
	0x00EB, 0x00CB, eos,
	0x00EC, 0x00CC, eos,	//  122
	0x00ED, 0x00CD, eos,
	0x00EE, 0x00CE, eos,
	0x00EF, 0x00CF, eos,	//  131
	0x00F0, 0x00D0, eos,
	0x00F1, 0x00D1, eos,
	0x00F2, 0x00D2, eos,	//  140
	0x00F3, 0x00D3, eos,
	0x00F4, 0x00D4, eos,
	0x00F5, 0x00D5, eos,
	0x00F6, 0x00D6, eos,	//  152
	0x00F8, 0x00D8, eos,
	0x00F9, 0x00D9, eos,
	0x00FA, 0x00DA, eos,	//  161
	0x00FB, 0x00DB, eos,
	0x00FC, 0x00DC, eos,
	0x00FD, 0x00DD, eos,	//  170
	0x00FE, 0x00DE, eos,
	0x0101, 0x0100, eos,
	0x0103, 0x0102, eos,
	0x0105, 0x0104, eos,	//  182
	0x0107, 0x0106, eos,
	0x0109, 0x0108, eos,
	0x010B, 0x010A, eos,	//  191
	0x010D, 0x010C, eos,
	0x010F, 0x010E, eos,
	0x0111, 0x0110, eos,	//  200
	0x0113, 0x0112, eos,
	0x0115, 0x0114, eos,
	0x0117, 0x0116, eos,
	0x0119, 0x0118, eos,	//  212
	0x011B, 0x011A, eos,
	0x011D, 0x011C, eos,
	0x011F, 0x011E, eos,	//  221
	0x0121, 0x0120, eos,
	0x0123, 0x0122, eos,
	0x0125, 0x0124, eos,	//  230
	0x0127, 0x0126, eos,
	0x0129, 0x0128, eos,
	0x012B, 0x012A, eos,
	0x012D, 0x012C, eos,	//  242
	0x012F, 0x012E, eos,
	0x0133, 0x0132, eos,
	0x0135, 0x0134, eos,	//  251
	0x0137, 0x0136, eos,
	0x013A, 0x0139, eos,
	0x013C, 0x013B, eos,	//  260
	0x013E, 0x013D, eos,
	0x0140, 0x013F, eos,
	0x0142, 0x0141, eos,
	0x0144, 0x0143, eos,	//  272
	0x0146, 0x0145, eos,
	0x0148, 0x0147, eos,
	0x014B, 0x014A, eos,	//  281
	0x014D, 0x014C, eos,
	0x014F, 0x014E, eos,
	0x0151, 0x0150, eos,	//  290
	0x0153, 0x0152, eos,
	0x0155, 0x0154, eos,
	0x0157, 0x0156, eos,
	0x0159, 0x0158, eos,	//  302
	0x015B, 0x015A, eos,
	0x015D, 0x015C, eos,
	0x015F, 0x015E, eos,	//  311
	0x0161, 0x0160, eos,
	0x0163, 0x0162, eos,
	0x0165, 0x0164, eos,	//  320
	0x0167, 0x0166, eos,
	0x0169, 0x0168, eos,
	0x016B, 0x016A, eos,
	0x016D, 0x016C, eos,	//  332
	0x016F, 0x016E, eos,
	0x0171, 0x0170, eos,
	0x0173, 0x0172, eos,	//  341
	0x0175, 0x0174, eos,
	0x0177, 0x0176, eos,
	0x00FF, 0x0178, eos,	//  350
	0x017A, 0x0179, eos,
	0x017C, 0x017B, eos,
	0x017E, 0x017D, eos,
	0x0253, 0x0181, eos,	//  362
	0x0183, 0x0182, eos,
	0x0185, 0x0184, eos,
	0x0254, 0x0186, eos,	//  371
	0x0188, 0x0187, eos,
	0x0256, 0x0189, eos,
	0x0257, 0x018A, eos,	//  380
	0x018C, 0x018B, eos,
	0x01DD, 0x018E, eos,
	0x0259, 0x018F, eos,
	0x025B, 0x0190, eos,	//  392
	0x0192, 0x0191, eos,
	0x0260, 0x0193, eos,
	0x0263, 0x0194, eos,	//  401
	0x0269, 0x0196, eos,
	0x0268, 0x0197, eos,
	0x0199, 0x0198, eos,	//  410
	0x026F, 0x019C, eos,
	0x0272, 0x019D, eos,
	0x0275, 0x019F, eos,
	0x01A1, 0x01A0, eos,	//  422
	0x01A3, 0x01A2, eos,
	0x01A5, 0x01A4, eos,
	0x0280, 0x01A6, eos,	//  431
	0x01A8, 0x01A7, eos,
	0x0283, 0x01A9, eos,
	0x01AD, 0x01AC, eos,	//  440
	0x0288, 0x01AE, eos,
	0x01B0, 0x01AF, eos,
	0x028A, 0x01B1, eos,
	0x028B, 0x01B2, eos,	//  452
	0x01B4, 0x01B3, eos,
	0x01B6, 0x01B5, eos,
	0x0292, 0x01B7, eos,	//  461
	0x01B9, 0x01B8, eos,
	0x01BD, 0x01BC, eos,
	0x01C6, 0x01C4, 0x01C5, eos,	//  470
	0x01C9, 0x01C7, 0x01C8, eos,
	0x01CC, 0x01CA, 0x01CB, eos,
	0x01CE, 0x01CD, eos,	//  482
	0x01D0, 0x01CF, eos,
	0x01D2, 0x01D1, eos,
	0x01D4, 0x01D3, eos,	//  491
	0x01D6, 0x01D5, eos,
	0x01D8, 0x01D7, eos,
	0x01DA, 0x01D9, eos,	//  500
	0x01DC, 0x01DB, eos,
	0x01DF, 0x01DE, eos,
	0x01E1, 0x01E0, eos,
	0x01E3, 0x01E2, eos,	//  512
	0x01E5, 0x01E4, eos,
	0x01E7, 0x01E6, eos,
	0x01E9, 0x01E8, eos,	//  521
	0x01EB, 0x01EA, eos,
	0x01ED, 0x01EC, eos,
	0x01EF, 0x01EE, eos,	//  530
	0x01F3, 0x01F1, 0x01F2, eos,
	0x01F5, 0x01F4, eos,
	0x0195, 0x01F6, eos,	//  540
	0x01BF, 0x01F7, eos,
	0x01F9, 0x01F8, eos,
	0x01FB, 0x01FA, eos,
	0x01FD, 0x01FC, eos,	//  552
	0x01FF, 0x01FE, eos,
	0x0201, 0x0200, eos,
	0x0203, 0x0202, eos,	//  561
	0x0205, 0x0204, eos,
	0x0207, 0x0206, eos,
	0x0209, 0x0208, eos,	//  570
	0x020B, 0x020A, eos,
	0x020D, 0x020C, eos,
	0x020F, 0x020E, eos,
	0x0211, 0x0210, eos,	//  582
	0x0213, 0x0212, eos,
	0x0215, 0x0214, eos,
	0x0217, 0x0216, eos,	//  591
	0x0219, 0x0218, eos,
	0x021B, 0x021A, eos,
	0x021D, 0x021C, eos,	//  600
	0x021F, 0x021E, eos,
	0x019E, 0x0220, eos,
	0x0223, 0x0222, eos,
	0x0225, 0x0224, eos,	//  612
	0x0227, 0x0226, eos,
	0x0229, 0x0228, eos,
	0x022B, 0x022A, eos,	//  621
	0x022D, 0x022C, eos,
	0x022F, 0x022E, eos,
	0x0231, 0x0230, eos,	//  630
	0x0233, 0x0232, eos,
	0x2C65, 0x023A, eos,
	0x023C, 0x023B, eos,
	0x019A, 0x023D, eos,	//  642
	0x2C66, 0x023E, eos,
	0x0242, 0x0241, eos,
	0x0180, 0x0243, eos,	//  651
	0x0289, 0x0244, eos,
	0x028C, 0x0245, eos,
	0x0247, 0x0246, eos,	//  660
	0x0249, 0x0248, eos,
	0x024B, 0x024A, eos,
	0x024D, 0x024C, eos,
	0x024F, 0x024E, eos,	//  672
	0x03B9, 0x0345, 0x0399, 0x1FBE, eos,
	0x0371, 0x0370, eos,	//  680
	0x0373, 0x0372, eos,
	0x0377, 0x0376, eos,
	0x03F3, 0x037F, eos,
	0x03AC, 0x0386, eos,	//  692
	0x03AD, 0x0388, eos,
	0x03AE, 0x0389, eos,
	0x03AF, 0x038A, eos,	//  701
	0x03CC, 0x038C, eos,
	0x03CD, 0x038E, eos,
	0x03CE, 0x038F, eos,	//  710
	0x03B1, 0x0391, eos,
	0x03B2, 0x0392, 0x03D0, eos,
	0x03B3, 0x0393, eos,	//  720
	0x03B4, 0x0394, eos,
	0x03B5, 0x0395, 0x03F5, eos,
	0x03B6, 0x0396, eos,	//  730
	0x03B7, 0x0397, eos,
	0x03B8, 0x0398, 0x03D1, 0x03F4, eos,
	0x03BA, 0x039A, 0x03F0, eos,	//  741
	0x03BB, 0x039B, eos,
	0x03BD, 0x039D, eos,
	0x03BE, 0x039E, eos,	//  751
	0x03BF, 0x039F, eos,
	0x03C0, 0x03A0, 0x03D6, eos,
	0x03C1, 0x03A1, 0x03F1, eos,	//  761
	0x03C3, 0x03A3, 0x03C2, eos,
	0x03C4, 0x03A4, eos,
	0x03C5, 0x03A5, eos,	//  772
	0x03C6, 0x03A6, 0x03D5, eos,
	0x03C7, 0x03A7, eos,
	0x03C8, 0x03A8, eos,	//  782
	0x03C9, 0x03A9, 0x2126, eos,
	0x03CA, 0x03AA, eos,
	0x03CB, 0x03AB, eos,	//  792
	0x03D7, 0x03CF, eos,
	0x03D9, 0x03D8, eos,
	0x03DB, 0x03DA, eos,	//  801
	0x03DD, 0x03DC, eos,
	0x03DF, 0x03DE, eos,
	0x03E1, 0x03E0, eos,	//  810
	0x03E3, 0x03E2, eos,
	0x03E5, 0x03E4, eos,
	0x03E7, 0x03E6, eos,
	0x03E9, 0x03E8, eos,	//  822
	0x03EB, 0x03EA, eos,
	0x03ED, 0x03EC, eos,
	0x03EF, 0x03EE, eos,	//  831
	0x03F8, 0x03F7, eos,
	0x03F2, 0x03F9, eos,
	0x03FB, 0x03FA, eos,	//  840
	0x037B, 0x03FD, eos,
	0x037C, 0x03FE, eos,
	0x037D, 0x03FF, eos,
	0x0450, 0x0400, eos,	//  852
	0x0451, 0x0401, eos,
	0x0452, 0x0402, eos,
	0x0453, 0x0403, eos,	//  861
	0x0454, 0x0404, eos,
	0x0455, 0x0405, eos,
	0x0456, 0x0406, eos,	//  870
	0x0457, 0x0407, eos,
	0x0458, 0x0408, eos,
	0x0459, 0x0409, eos,
	0x045A, 0x040A, eos,	//  882
	0x045B, 0x040B, eos,
	0x045C, 0x040C, eos,
	0x045D, 0x040D, eos,	//  891
	0x045E, 0x040E, eos,
	0x045F, 0x040F, eos,
	0x0430, 0x0410, eos,	//  900
	0x0431, 0x0411, eos,
	0x0432, 0x0412, 0x1C80, eos,
	0x0433, 0x0413, eos,	//  910
	0x0434, 0x0414, 0x1C81, eos,
	0x0435, 0x0415, eos,
	0x0436, 0x0416, eos,	//  920
	0x0437, 0x0417, eos,
	0x0438, 0x0418, eos,
	0x0439, 0x0419, eos,
	0x043A, 0x041A, eos,	//  932
	0x043B, 0x041B, eos,
	0x043C, 0x041C, eos,
	0x043D, 0x041D, eos,	//  941
	0x043E, 0x041E, 0x1C82, eos,
	0x043F, 0x041F, eos,
	0x0440, 0x0420, eos,	//  951
	0x0441, 0x0421, 0x1C83, eos,
	0x0442, 0x0422, 0x1C84, 0x1C85, eos,
	0x0443, 0x0423, eos,	//  963
	0x0444, 0x0424, eos,
	0x0445, 0x0425, eos,
	0x0446, 0x0426, eos,	//  972
	0x0447, 0x0427, eos,
	0x0448, 0x0428, eos,
	0x0449, 0x0429, eos,	//  981
	0x044A, 0x042A, 0x1C86, eos,
	0x044B, 0x042B, eos,
	0x044C, 0x042C, eos,	//  991
	0x044D, 0x042D, eos,
	0x044E, 0x042E, eos,
	0x044F, 0x042F, eos,	//  1000
	0x0461, 0x0460, eos,
	0x0463, 0x0462, 0x1C87, eos,
	0x0465, 0x0464, eos,	//  1010
	0x0467, 0x0466, eos,
	0x0469, 0x0468, eos,
	0x046B, 0x046A, eos,
	0x046D, 0x046C, eos,	//  1022
	0x046F, 0x046E, eos,
	0x0471, 0x0470, eos,
	0x0473, 0x0472, eos,	//  1031
	0x0475, 0x0474, eos,
	0x0477, 0x0476, eos,
	0x0479, 0x0478, eos,	//  1040
	0x047B, 0x047A, eos,
	0x047D, 0x047C, eos,
	0x047F, 0x047E, eos,
	0x0481, 0x0480, eos,	//  1052
	0x048B, 0x048A, eos,
	0x048D, 0x048C, eos,
	0x048F, 0x048E, eos,	//  1061
	0x0491, 0x0490, eos,
	0x0493, 0x0492, eos,
	0x0495, 0x0494, eos,	//  1070
	0x0497, 0x0496, eos,
	0x0499, 0x0498, eos,
	0x049B, 0x049A, eos,
	0x049D, 0x049C, eos,	//  1082
	0x049F, 0x049E, eos,
	0x04A1, 0x04A0, eos,
	0x04A3, 0x04A2, eos,	//  1091
	0x04A5, 0x04A4, eos,
	0x04A7, 0x04A6, eos,
	0x04A9, 0x04A8, eos,	//  1100
	0x04AB, 0x04AA, eos,
	0x04AD, 0x04AC, eos,
	0x04AF, 0x04AE, eos,
	0x04B1, 0x04B0, eos,	//  1112
	0x04B3, 0x04B2, eos,
	0x04B5, 0x04B4, eos,
	0x04B7, 0x04B6, eos,	//  1121
	0x04B9, 0x04B8, eos,
	0x04BB, 0x04BA, eos,
	0x04BD, 0x04BC, eos,	//  1130
	0x04BF, 0x04BE, eos,
	0x04CF, 0x04C0, eos,
	0x04C2, 0x04C1, eos,
	0x04C4, 0x04C3, eos,	//  1142
	0x04C6, 0x04C5, eos,
	0x04C8, 0x04C7, eos,
	0x04CA, 0x04C9, eos,	//  1151
	0x04CC, 0x04CB, eos,
	0x04CE, 0x04CD, eos,
	0x04D1, 0x04D0, eos,	//  1160
	0x04D3, 0x04D2, eos,
	0x04D5, 0x04D4, eos,
	0x04D7, 0x04D6, eos,
	0x04D9, 0x04D8, eos,	//  1172
	0x04DB, 0x04DA, eos,
	0x04DD, 0x04DC, eos,
	0x04DF, 0x04DE, eos,	//  1181
	0x04E1, 0x04E0, eos,
	0x04E3, 0x04E2, eos,
	0x04E5, 0x04E4, eos,	//  1190
	0x04E7, 0x04E6, eos,
	0x04E9, 0x04E8, eos,
	0x04EB, 0x04EA, eos,
	0x04ED, 0x04EC, eos,	//  1202
	0x04EF, 0x04EE, eos,
	0x04F1, 0x04F0, eos,
	0x04F3, 0x04F2, eos,	//  1211
	0x04F5, 0x04F4, eos,
	0x04F7, 0x04F6, eos,
	0x04F9, 0x04F8, eos,	//  1220
	0x04FB, 0x04FA, eos,
	0x04FD, 0x04FC, eos,
	0x04FF, 0x04FE, eos,
	0x0501, 0x0500, eos,	//  1232
	0x0503, 0x0502, eos,
	0x0505, 0x0504, eos,
	0x0507, 0x0506, eos,	//  1241
	0x0509, 0x0508, eos,
	0x050B, 0x050A, eos,
	0x050D, 0x050C, eos,	//  1250
	0x050F, 0x050E, eos,
	0x0511, 0x0510, eos,
	0x0513, 0x0512, eos,
	0x0515, 0x0514, eos,	//  1262
	0x0517, 0x0516, eos,
	0x0519, 0x0518, eos,
	0x051B, 0x051A, eos,	//  1271
	0x051D, 0x051C, eos,
	0x051F, 0x051E, eos,
	0x0521, 0x0520, eos,	//  1280
	0x0523, 0x0522, eos,
	0x0525, 0x0524, eos,
	0x0527, 0x0526, eos,
	0x0529, 0x0528, eos,	//  1292
	0x052B, 0x052A, eos,
	0x052D, 0x052C, eos,
	0x052F, 0x052E, eos,	//  1301
	0x0561, 0x0531, eos,
	0x0562, 0x0532, eos,
	0x0563, 0x0533, eos,	//  1310
	0x0564, 0x0534, eos,
	0x0565, 0x0535, eos,
	0x0566, 0x0536, eos,
	0x0567, 0x0537, eos,	//  1322
	0x0568, 0x0538, eos,
	0x0569, 0x0539, eos,
	0x056A, 0x053A, eos,	//  1331
	0x056B, 0x053B, eos,
	0x056C, 0x053C, eos,
	0x056D, 0x053D, eos,	//  1340
	0x056E, 0x053E, eos,
	0x056F, 0x053F, eos,
	0x0570, 0x0540, eos,
	0x0571, 0x0541, eos,	//  1352
	0x0572, 0x0542, eos,
	0x0573, 0x0543, eos,
	0x0574, 0x0544, eos,	//  1361
	0x0575, 0x0545, eos,
	0x0576, 0x0546, eos,
	0x0577, 0x0547, eos,	//  1370
	0x0578, 0x0548, eos,
	0x0579, 0x0549, eos,
	0x057A, 0x054A, eos,
	0x057B, 0x054B, eos,	//  1382
	0x057C, 0x054C, eos,
	0x057D, 0x054D, eos,
	0x057E, 0x054E, eos,	//  1391
	0x057F, 0x054F, eos,
	0x0580, 0x0550, eos,
	0x0581, 0x0551, eos,	//  1400
	0x0582, 0x0552, eos,
	0x0583, 0x0553, eos,
	0x0584, 0x0554, eos,
	0x0585, 0x0555, eos,	//  1412
	0x0586, 0x0556, eos,
	0x2D00, 0x10A0, eos,
	0x2D01, 0x10A1, eos,	//  1421
	0x2D02, 0x10A2, eos,
	0x2D03, 0x10A3, eos,
	0x2D04, 0x10A4, eos,	//  1430
	0x2D05, 0x10A5, eos,
	0x2D06, 0x10A6, eos,
	0x2D07, 0x10A7, eos,
	0x2D08, 0x10A8, eos,	//  1442
	0x2D09, 0x10A9, eos,
	0x2D0A, 0x10AA, eos,
	0x2D0B, 0x10AB, eos,	//  1451
	0x2D0C, 0x10AC, eos,
	0x2D0D, 0x10AD, eos,
	0x2D0E, 0x10AE, eos,	//  1460
	0x2D0F, 0x10AF, eos,
	0x2D10, 0x10B0, eos,
	0x2D11, 0x10B1, eos,
	0x2D12, 0x10B2, eos,	//  1472
	0x2D13, 0x10B3, eos,
	0x2D14, 0x10B4, eos,
	0x2D15, 0x10B5, eos,	//  1481
	0x2D16, 0x10B6, eos,
	0x2D17, 0x10B7, eos,
	0x2D18, 0x10B8, eos,	//  1490
	0x2D19, 0x10B9, eos,
	0x2D1A, 0x10BA, eos,
	0x2D1B, 0x10BB, eos,
	0x2D1C, 0x10BC, eos,	//  1502
	0x2D1D, 0x10BD, eos,
	0x2D1E, 0x10BE, eos,
	0x2D1F, 0x10BF, eos,	//  1511
	0x2D20, 0x10C0, eos,
	0x2D21, 0x10C1, eos,
	0x2D22, 0x10C2, eos,	//  1520
	0x2D23, 0x10C3, eos,
	0x2D24, 0x10C4, eos,
	0x2D25, 0x10C5, eos,
	0x2D27, 0x10C7, eos,	//  1532
	0x2D2D, 0x10CD, eos,
	0x13F0, 0x13F8, eos,
	0x13F1, 0x13F9, eos,	//  1541
	0x13F2, 0x13FA, eos,
	0x13F3, 0x13FB, eos,
	0x13F4, 0x13FC, eos,	//  1550
	0x13F5, 0x13FD, eos,
	0xA64B, 0x1C88, 0xA64A, eos,
	0x10D0, 0x1C90, eos,	//  1560
	0x10D1, 0x1C91, eos,
	0x10D2, 0x1C92, eos,
	0x10D3, 0x1C93, eos,
	0x10D4, 0x1C94, eos,	//  1572
	0x10D5, 0x1C95, eos,
	0x10D6, 0x1C96, eos,
	0x10D7, 0x1C97, eos,	//  1581
	0x10D8, 0x1C98, eos,
	0x10D9, 0x1C99, eos,
	0x10DA, 0x1C9A, eos,	//  1590
	0x10DB, 0x1C9B, eos,
	0x10DC, 0x1C9C, eos,
	0x10DD, 0x1C9D, eos,
	0x10DE, 0x1C9E, eos,	//  1602
	0x10DF, 0x1C9F, eos,
	0x10E0, 0x1CA0, eos,
	0x10E1, 0x1CA1, eos,	//  1611
	0x10E2, 0x1CA2, eos,
	0x10E3, 0x1CA3, eos,
	0x10E4, 0x1CA4, eos,	//  1620
	0x10E5, 0x1CA5, eos,
	0x10E6, 0x1CA6, eos,
	0x10E7, 0x1CA7, eos,
	0x10E8, 0x1CA8, eos,	//  1632
	0x10E9, 0x1CA9, eos,
	0x10EA, 0x1CAA, eos,
	0x10EB, 0x1CAB, eos,	//  1641
	0x10EC, 0x1CAC, eos,
	0x10ED, 0x1CAD, eos,
	0x10EE, 0x1CAE, eos,	//  1650
	0x10EF, 0x1CAF, eos,
	0x10F0, 0x1CB0, eos,
	0x10F1, 0x1CB1, eos,
	0x10F2, 0x1CB2, eos,	//  1662
	0x10F3, 0x1CB3, eos,
	0x10F4, 0x1CB4, eos,
	0x10F5, 0x1CB5, eos,	//  1671
	0x10F6, 0x1CB6, eos,
	0x10F7, 0x1CB7, eos,
	0x10F8, 0x1CB8, eos,	//  1680
	0x10F9, 0x1CB9, eos,
	0x10FA, 0x1CBA, eos,
	0x10FD, 0x1CBD, eos,
	0x10FE, 0x1CBE, eos,	//  1692
	0x10FF, 0x1CBF, eos,
	0x1E01, 0x1E00, eos,
	0x1E03, 0x1E02, eos,	//  1701
	0x1E05, 0x1E04, eos,
	0x1E07, 0x1E06, eos,
	0x1E09, 0x1E08, eos,	//  1710
	0x1E0B, 0x1E0A, eos,
	0x1E0D, 0x1E0C, eos,
	0x1E0F, 0x1E0E, eos,
	0x1E11, 0x1E10, eos,	//  1722
	0x1E13, 0x1E12, eos,
	0x1E15, 0x1E14, eos,
	0x1E17, 0x1E16, eos,	//  1731
	0x1E19, 0x1E18, eos,
	0x1E1B, 0x1E1A, eos,
	0x1E1D, 0x1E1C, eos,	//  1740
	0x1E1F, 0x1E1E, eos,
	0x1E21, 0x1E20, eos,
	0x1E23, 0x1E22, eos,
	0x1E25, 0x1E24, eos,	//  1752
	0x1E27, 0x1E26, eos,
	0x1E29, 0x1E28, eos,
	0x1E2B, 0x1E2A, eos,	//  1761
	0x1E2D, 0x1E2C, eos,
	0x1E2F, 0x1E2E, eos,
	0x1E31, 0x1E30, eos,	//  1770
	0x1E33, 0x1E32, eos,
	0x1E35, 0x1E34, eos,
	0x1E37, 0x1E36, eos,
	0x1E39, 0x1E38, eos,	//  1782
	0x1E3B, 0x1E3A, eos,
	0x1E3D, 0x1E3C, eos,
	0x1E3F, 0x1E3E, eos,	//  1791
	0x1E41, 0x1E40, eos,
	0x1E43, 0x1E42, eos,
	0x1E45, 0x1E44, eos,	//  1800
	0x1E47, 0x1E46, eos,
	0x1E49, 0x1E48, eos,
	0x1E4B, 0x1E4A, eos,
	0x1E4D, 0x1E4C, eos,	//  1812
	0x1E4F, 0x1E4E, eos,
	0x1E51, 0x1E50, eos,
	0x1E53, 0x1E52, eos,	//  1821
	0x1E55, 0x1E54, eos,
	0x1E57, 0x1E56, eos,
	0x1E59, 0x1E58, eos,	//  1830
	0x1E5B, 0x1E5A, eos,
	0x1E5D, 0x1E5C, eos,
	0x1E5F, 0x1E5E, eos,
	0x1E61, 0x1E60, 0x1E9B, eos,	//  1842
	0x1E63, 0x1E62, eos,
	0x1E65, 0x1E64, eos,
	0x1E67, 0x1E66, eos,	//  1852
	0x1E69, 0x1E68, eos,
	0x1E6B, 0x1E6A, eos,
	0x1E6D, 0x1E6C, eos,	//  1861
	0x1E6F, 0x1E6E, eos,
	0x1E71, 0x1E70, eos,
	0x1E73, 0x1E72, eos,	//  1870
	0x1E75, 0x1E74, eos,
	0x1E77, 0x1E76, eos,
	0x1E79, 0x1E78, eos,
	0x1E7B, 0x1E7A, eos,	//  1882
	0x1E7D, 0x1E7C, eos,
	0x1E7F, 0x1E7E, eos,
	0x1E81, 0x1E80, eos,	//  1891
	0x1E83, 0x1E82, eos,
	0x1E85, 0x1E84, eos,
	0x1E87, 0x1E86, eos,	//  1900
	0x1E89, 0x1E88, eos,
	0x1E8B, 0x1E8A, eos,
	0x1E8D, 0x1E8C, eos,
	0x1E8F, 0x1E8E, eos,	//  1912
	0x1E91, 0x1E90, eos,
	0x1E93, 0x1E92, eos,
	0x1E95, 0x1E94, eos,	//  1921
	0x00DF, 0x1E9E, eos,
	0x1EA1, 0x1EA0, eos,
	0x1EA3, 0x1EA2, eos,	//  1930
	0x1EA5, 0x1EA4, eos,
	0x1EA7, 0x1EA6, eos,
	0x1EA9, 0x1EA8, eos,
	0x1EAB, 0x1EAA, eos,	//  1942
	0x1EAD, 0x1EAC, eos,
	0x1EAF, 0x1EAE, eos,
	0x1EB1, 0x1EB0, eos,	//  1951
	0x1EB3, 0x1EB2, eos,
	0x1EB5, 0x1EB4, eos,
	0x1EB7, 0x1EB6, eos,	//  1960
	0x1EB9, 0x1EB8, eos,
	0x1EBB, 0x1EBA, eos,
	0x1EBD, 0x1EBC, eos,
	0x1EBF, 0x1EBE, eos,	//  1972
	0x1EC1, 0x1EC0, eos,
	0x1EC3, 0x1EC2, eos,
	0x1EC5, 0x1EC4, eos,	//  1981
	0x1EC7, 0x1EC6, eos,
	0x1EC9, 0x1EC8, eos,
	0x1ECB, 0x1ECA, eos,	//  1990
	0x1ECD, 0x1ECC, eos,
	0x1ECF, 0x1ECE, eos,
	0x1ED1, 0x1ED0, eos,
	0x1ED3, 0x1ED2, eos,	//  2002
	0x1ED5, 0x1ED4, eos,
	0x1ED7, 0x1ED6, eos,
	0x1ED9, 0x1ED8, eos,	//  2011
	0x1EDB, 0x1EDA, eos,
	0x1EDD, 0x1EDC, eos,
	0x1EDF, 0x1EDE, eos,	//  2020
	0x1EE1, 0x1EE0, eos,
	0x1EE3, 0x1EE2, eos,
	0x1EE5, 0x1EE4, eos,
	0x1EE7, 0x1EE6, eos,	//  2032
	0x1EE9, 0x1EE8, eos,
	0x1EEB, 0x1EEA, eos,
	0x1EED, 0x1EEC, eos,	//  2041
	0x1EEF, 0x1EEE, eos,
	0x1EF1, 0x1EF0, eos,
	0x1EF3, 0x1EF2, eos,	//  2050
	0x1EF5, 0x1EF4, eos,
	0x1EF7, 0x1EF6, eos,
	0x1EF9, 0x1EF8, eos,
	0x1EFB, 0x1EFA, eos,	//  2062
	0x1EFD, 0x1EFC, eos,
	0x1EFF, 0x1EFE, eos,
	0x1F00, 0x1F08, eos,	//  2071
	0x1F01, 0x1F09, eos,
	0x1F02, 0x1F0A, eos,
	0x1F03, 0x1F0B, eos,	//  2080
	0x1F04, 0x1F0C, eos,
	0x1F05, 0x1F0D, eos,
	0x1F06, 0x1F0E, eos,
	0x1F07, 0x1F0F, eos,	//  2092
	0x1F10, 0x1F18, eos,
	0x1F11, 0x1F19, eos,
	0x1F12, 0x1F1A, eos,	//  2101
	0x1F13, 0x1F1B, eos,
	0x1F14, 0x1F1C, eos,
	0x1F15, 0x1F1D, eos,	//  2110
	0x1F20, 0x1F28, eos,
	0x1F21, 0x1F29, eos,
	0x1F22, 0x1F2A, eos,
	0x1F23, 0x1F2B, eos,	//  2122
	0x1F24, 0x1F2C, eos,
	0x1F25, 0x1F2D, eos,
	0x1F26, 0x1F2E, eos,	//  2131
	0x1F27, 0x1F2F, eos,
	0x1F30, 0x1F38, eos,
	0x1F31, 0x1F39, eos,	//  2140
	0x1F32, 0x1F3A, eos,
	0x1F33, 0x1F3B, eos,
	0x1F34, 0x1F3C, eos,
	0x1F35, 0x1F3D, eos,	//  2152
	0x1F36, 0x1F3E, eos,
	0x1F37, 0x1F3F, eos,
	0x1F40, 0x1F48, eos,	//  2161
	0x1F41, 0x1F49, eos,
	0x1F42, 0x1F4A, eos,
	0x1F43, 0x1F4B, eos,	//  2170
	0x1F44, 0x1F4C, eos,
	0x1F45, 0x1F4D, eos,
	0x1F51, 0x1F59, eos,
	0x1F53, 0x1F5B, eos,	//  2182
	0x1F55, 0x1F5D, eos,
	0x1F57, 0x1F5F, eos,
	0x1F60, 0x1F68, eos,	//  2191
	0x1F61, 0x1F69, eos,
	0x1F62, 0x1F6A, eos,
	0x1F63, 0x1F6B, eos,	//  2200
	0x1F64, 0x1F6C, eos,
	0x1F65, 0x1F6D, eos,
	0x1F66, 0x1F6E, eos,
	0x1F67, 0x1F6F, eos,	//  2212
	0x1F80, 0x1F88, eos,
	0x1F81, 0x1F89, eos,
	0x1F82, 0x1F8A, eos,	//  2221
	0x1F83, 0x1F8B, eos,
	0x1F84, 0x1F8C, eos,
	0x1F85, 0x1F8D, eos,	//  2230
	0x1F86, 0x1F8E, eos,
	0x1F87, 0x1F8F, eos,
	0x1F90, 0x1F98, eos,
	0x1F91, 0x1F99, eos,	//  2242
	0x1F92, 0x1F9A, eos,
	0x1F93, 0x1F9B, eos,
	0x1F94, 0x1F9C, eos,	//  2251
	0x1F95, 0x1F9D, eos,
	0x1F96, 0x1F9E, eos,
	0x1F97, 0x1F9F, eos,	//  2260
	0x1FA0, 0x1FA8, eos,
	0x1FA1, 0x1FA9, eos,
	0x1FA2, 0x1FAA, eos,
	0x1FA3, 0x1FAB, eos,	//  2272
	0x1FA4, 0x1FAC, eos,
	0x1FA5, 0x1FAD, eos,
	0x1FA6, 0x1FAE, eos,	//  2281
	0x1FA7, 0x1FAF, eos,
	0x1FB0, 0x1FB8, eos,
	0x1FB1, 0x1FB9, eos,	//  2290
	0x1F70, 0x1FBA, eos,
	0x1F71, 0x1FBB, eos,
	0x1FB3, 0x1FBC, eos,
	0x1F72, 0x1FC8, eos,	//  2302
	0x1F73, 0x1FC9, eos,
	0x1F74, 0x1FCA, eos,
	0x1F75, 0x1FCB, eos,	//  2311
	0x1FC3, 0x1FCC, eos,
	0x0390, 0x1FD3, eos,
	0x1FD0, 0x1FD8, eos,	//  2320
	0x1FD1, 0x1FD9, eos,
	0x1F76, 0x1FDA, eos,
	0x1F77, 0x1FDB, eos,
	0x03B0, 0x1FE3, eos,	//  2332
	0x1FE0, 0x1FE8, eos,
	0x1FE1, 0x1FE9, eos,
	0x1F7A, 0x1FEA, eos,	//  2341
	0x1F7B, 0x1FEB, eos,
	0x1FE5, 0x1FEC, eos,
	0x1F78, 0x1FF8, eos,	//  2350
	0x1F79, 0x1FF9, eos,
	0x1F7C, 0x1FFA, eos,
	0x1F7D, 0x1FFB, eos,
	0x1FF3, 0x1FFC, eos,	//  2362
	0x214E, 0x2132, eos,
	0x2170, 0x2160, eos,
	0x2171, 0x2161, eos,	//  2371
	0x2172, 0x2162, eos,
	0x2173, 0x2163, eos,
	0x2174, 0x2164, eos,	//  2380
	0x2175, 0x2165, eos,
	0x2176, 0x2166, eos,
	0x2177, 0x2167, eos,
	0x2178, 0x2168, eos,	//  2392
	0x2179, 0x2169, eos,
	0x217A, 0x216A, eos,
	0x217B, 0x216B, eos,	//  2401
	0x217C, 0x216C, eos,
	0x217D, 0x216D, eos,
	0x217E, 0x216E, eos,	//  2410
	0x217F, 0x216F, eos,
	0x2184, 0x2183, eos,
	0x24D0, 0x24B6, eos,
	0x24D1, 0x24B7, eos,	//  2422
	0x24D2, 0x24B8, eos,
	0x24D3, 0x24B9, eos,
	0x24D4, 0x24BA, eos,	//  2431
	0x24D5, 0x24BB, eos,
	0x24D6, 0x24BC, eos,
	0x24D7, 0x24BD, eos,	//  2440
	0x24D8, 0x24BE, eos,
	0x24D9, 0x24BF, eos,
	0x24DA, 0x24C0, eos,
	0x24DB, 0x24C1, eos,	//  2452
	0x24DC, 0x24C2, eos,
	0x24DD, 0x24C3, eos,
	0x24DE, 0x24C4, eos,	//  2461
	0x24DF, 0x24C5, eos,
	0x24E0, 0x24C6, eos,
	0x24E1, 0x24C7, eos,	//  2470
	0x24E2, 0x24C8, eos,
	0x24E3, 0x24C9, eos,
	0x24E4, 0x24CA, eos,
	0x24E5, 0x24CB, eos,	//  2482
	0x24E6, 0x24CC, eos,
	0x24E7, 0x24CD, eos,
	0x24E8, 0x24CE, eos,	//  2491
	0x24E9, 0x24CF, eos,
	0x2C30, 0x2C00, eos,
	0x2C31, 0x2C01, eos,	//  2500
	0x2C32, 0x2C02, eos,
	0x2C33, 0x2C03, eos,
	0x2C34, 0x2C04, eos,
	0x2C35, 0x2C05, eos,	//  2512
	0x2C36, 0x2C06, eos,
	0x2C37, 0x2C07, eos,
	0x2C38, 0x2C08, eos,	//  2521
	0x2C39, 0x2C09, eos,
	0x2C3A, 0x2C0A, eos,
	0x2C3B, 0x2C0B, eos,	//  2530
	0x2C3C, 0x2C0C, eos,
	0x2C3D, 0x2C0D, eos,
	0x2C3E, 0x2C0E, eos,
	0x2C3F, 0x2C0F, eos,	//  2542
	0x2C40, 0x2C10, eos,
	0x2C41, 0x2C11, eos,
	0x2C42, 0x2C12, eos,	//  2551
	0x2C43, 0x2C13, eos,
	0x2C44, 0x2C14, eos,
	0x2C45, 0x2C15, eos,	//  2560
	0x2C46, 0x2C16, eos,
	0x2C47, 0x2C17, eos,
	0x2C48, 0x2C18, eos,
	0x2C49, 0x2C19, eos,	//  2572
	0x2C4A, 0x2C1A, eos,
	0x2C4B, 0x2C1B, eos,
	0x2C4C, 0x2C1C, eos,	//  2581
	0x2C4D, 0x2C1D, eos,
	0x2C4E, 0x2C1E, eos,
	0x2C4F, 0x2C1F, eos,	//  2590
	0x2C50, 0x2C20, eos,
	0x2C51, 0x2C21, eos,
	0x2C52, 0x2C22, eos,
	0x2C53, 0x2C23, eos,	//  2602
	0x2C54, 0x2C24, eos,
	0x2C55, 0x2C25, eos,
	0x2C56, 0x2C26, eos,	//  2611
	0x2C57, 0x2C27, eos,
	0x2C58, 0x2C28, eos,
	0x2C59, 0x2C29, eos,	//  2620
	0x2C5A, 0x2C2A, eos,
	0x2C5B, 0x2C2B, eos,
	0x2C5C, 0x2C2C, eos,
	0x2C5D, 0x2C2D, eos,	//  2632
	0x2C5E, 0x2C2E, eos,
	0x2C5F, 0x2C2F, eos,
	0x2C61, 0x2C60, eos,	//  2641
	0x026B, 0x2C62, eos,
	0x1D7D, 0x2C63, eos,
	0x027D, 0x2C64, eos,	//  2650
	0x2C68, 0x2C67, eos,
	0x2C6A, 0x2C69, eos,
	0x2C6C, 0x2C6B, eos,
	0x0251, 0x2C6D, eos,	//  2662
	0x0271, 0x2C6E, eos,
	0x0250, 0x2C6F, eos,
	0x0252, 0x2C70, eos,	//  2671
	0x2C73, 0x2C72, eos,
	0x2C76, 0x2C75, eos,
	0x023F, 0x2C7E, eos,	//  2680
	0x0240, 0x2C7F, eos,
	0x2C81, 0x2C80, eos,
	0x2C83, 0x2C82, eos,
	0x2C85, 0x2C84, eos,	//  2692
	0x2C87, 0x2C86, eos,
	0x2C89, 0x2C88, eos,
	0x2C8B, 0x2C8A, eos,	//  2701
	0x2C8D, 0x2C8C, eos,
	0x2C8F, 0x2C8E, eos,
	0x2C91, 0x2C90, eos,	//  2710
	0x2C93, 0x2C92, eos,
	0x2C95, 0x2C94, eos,
	0x2C97, 0x2C96, eos,
	0x2C99, 0x2C98, eos,	//  2722
	0x2C9B, 0x2C9A, eos,
	0x2C9D, 0x2C9C, eos,
	0x2C9F, 0x2C9E, eos,	//  2731
	0x2CA1, 0x2CA0, eos,
	0x2CA3, 0x2CA2, eos,
	0x2CA5, 0x2CA4, eos,	//  2740
	0x2CA7, 0x2CA6, eos,
	0x2CA9, 0x2CA8, eos,
	0x2CAB, 0x2CAA, eos,
	0x2CAD, 0x2CAC, eos,	//  2752
	0x2CAF, 0x2CAE, eos,
	0x2CB1, 0x2CB0, eos,
	0x2CB3, 0x2CB2, eos,	//  2761
	0x2CB5, 0x2CB4, eos,
	0x2CB7, 0x2CB6, eos,
	0x2CB9, 0x2CB8, eos,	//  2770
	0x2CBB, 0x2CBA, eos,
	0x2CBD, 0x2CBC, eos,
	0x2CBF, 0x2CBE, eos,
	0x2CC1, 0x2CC0, eos,	//  2782
	0x2CC3, 0x2CC2, eos,
	0x2CC5, 0x2CC4, eos,
	0x2CC7, 0x2CC6, eos,	//  2791
	0x2CC9, 0x2CC8, eos,
	0x2CCB, 0x2CCA, eos,
	0x2CCD, 0x2CCC, eos,	//  2800
	0x2CCF, 0x2CCE, eos,
	0x2CD1, 0x2CD0, eos,
	0x2CD3, 0x2CD2, eos,
	0x2CD5, 0x2CD4, eos,	//  2812
	0x2CD7, 0x2CD6, eos,
	0x2CD9, 0x2CD8, eos,
	0x2CDB, 0x2CDA, eos,	//  2821
	0x2CDD, 0x2CDC, eos,
	0x2CDF, 0x2CDE, eos,
	0x2CE1, 0x2CE0, eos,	//  2830
	0x2CE3, 0x2CE2, eos,
	0x2CEC, 0x2CEB, eos,
	0x2CEE, 0x2CED, eos,
	0x2CF3, 0x2CF2, eos,	//  2842
	0xA641, 0xA640, eos,
	0xA643, 0xA642, eos,
	0xA645, 0xA644, eos,	//  2851
	0xA647, 0xA646, eos,
	0xA649, 0xA648, eos,
	0xA64D, 0xA64C, eos,	//  2860
	0xA64F, 0xA64E, eos,
	0xA651, 0xA650, eos,
	0xA653, 0xA652, eos,
	0xA655, 0xA654, eos,	//  2872
	0xA657, 0xA656, eos,
	0xA659, 0xA658, eos,
	0xA65B, 0xA65A, eos,	//  2881
	0xA65D, 0xA65C, eos,
	0xA65F, 0xA65E, eos,
	0xA661, 0xA660, eos,	//  2890
	0xA663, 0xA662, eos,
	0xA665, 0xA664, eos,
	0xA667, 0xA666, eos,
	0xA669, 0xA668, eos,	//  2902
	0xA66B, 0xA66A, eos,
	0xA66D, 0xA66C, eos,
	0xA681, 0xA680, eos,	//  2911
	0xA683, 0xA682, eos,
	0xA685, 0xA684, eos,
	0xA687, 0xA686, eos,	//  2920
	0xA689, 0xA688, eos,
	0xA68B, 0xA68A, eos,
	0xA68D, 0xA68C, eos,
	0xA68F, 0xA68E, eos,	//  2932
	0xA691, 0xA690, eos,
	0xA693, 0xA692, eos,
	0xA695, 0xA694, eos,	//  2941
	0xA697, 0xA696, eos,
	0xA699, 0xA698, eos,
	0xA69B, 0xA69A, eos,	//  2950
	0xA723, 0xA722, eos,
	0xA725, 0xA724, eos,
	0xA727, 0xA726, eos,
	0xA729, 0xA728, eos,	//  2962
	0xA72B, 0xA72A, eos,
	0xA72D, 0xA72C, eos,
	0xA72F, 0xA72E, eos,	//  2971
	0xA733, 0xA732, eos,
	0xA735, 0xA734, eos,
	0xA737, 0xA736, eos,	//  2980
	0xA739, 0xA738, eos,
	0xA73B, 0xA73A, eos,
	0xA73D, 0xA73C, eos,
	0xA73F, 0xA73E, eos,	//  2992
	0xA741, 0xA740, eos,
	0xA743, 0xA742, eos,
	0xA745, 0xA744, eos,	//  3001
	0xA747, 0xA746, eos,
	0xA749, 0xA748, eos,
	0xA74B, 0xA74A, eos,	//  3010
	0xA74D, 0xA74C, eos,
	0xA74F, 0xA74E, eos,
	0xA751, 0xA750, eos,
	0xA753, 0xA752, eos,	//  3022
	0xA755, 0xA754, eos,
	0xA757, 0xA756, eos,
	0xA759, 0xA758, eos,	//  3031
	0xA75B, 0xA75A, eos,
	0xA75D, 0xA75C, eos,
	0xA75F, 0xA75E, eos,	//  3040
	0xA761, 0xA760, eos,
	0xA763, 0xA762, eos,
	0xA765, 0xA764, eos,
	0xA767, 0xA766, eos,	//  3052
	0xA769, 0xA768, eos,
	0xA76B, 0xA76A, eos,
	0xA76D, 0xA76C, eos,	//  3061
	0xA76F, 0xA76E, eos,
	0xA77A, 0xA779, eos,
	0xA77C, 0xA77B, eos,	//  3070
	0x1D79, 0xA77D, eos,
	0xA77F, 0xA77E, eos,
	0xA781, 0xA780, eos,
	0xA783, 0xA782, eos,	//  3082
	0xA785, 0xA784, eos,
	0xA787, 0xA786, eos,
	0xA78C, 0xA78B, eos,	//  3091
	0x0265, 0xA78D, eos,
	0xA791, 0xA790, eos,
	0xA793, 0xA792, eos,	//  3100
	0xA797, 0xA796, eos,
	0xA799, 0xA798, eos,
	0xA79B, 0xA79A, eos,
	0xA79D, 0xA79C, eos,	//  3112
	0xA79F, 0xA79E, eos,
	0xA7A1, 0xA7A0, eos,
	0xA7A3, 0xA7A2, eos,	//  3121
	0xA7A5, 0xA7A4, eos,
	0xA7A7, 0xA7A6, eos,
	0xA7A9, 0xA7A8, eos,	//  3130
	0x0266, 0xA7AA, eos,
	0x025C, 0xA7AB, eos,
	0x0261, 0xA7AC, eos,
	0x026C, 0xA7AD, eos,	//  3142
	0x026A, 0xA7AE, eos,
	0x029E, 0xA7B0, eos,
	0x0287, 0xA7B1, eos,	//  3151
	0x029D, 0xA7B2, eos,
	0xAB53, 0xA7B3, eos,
	0xA7B5, 0xA7B4, eos,	//  3160
	0xA7B7, 0xA7B6, eos,
	0xA7B9, 0xA7B8, eos,
	0xA7BB, 0xA7BA, eos,
	0xA7BD, 0xA7BC, eos,	//  3172
	0xA7BF, 0xA7BE, eos,
	0xA7C1, 0xA7C0, eos,
	0xA7C3, 0xA7C2, eos,	//  3181
	0xA794, 0xA7C4, eos,
	0x0282, 0xA7C5, eos,
	0x1D8E, 0xA7C6, eos,	//  3190
	0xA7C8, 0xA7C7, eos,
	0xA7CA, 0xA7C9, eos,
	0xA7D1, 0xA7D0, eos,
	0xA7D7, 0xA7D6, eos,	//  3202
	0xA7D9, 0xA7D8, eos,
	0xA7F6, 0xA7F5, eos,
	0x13A0, 0xAB70, eos,	//  3211
	0x13A1, 0xAB71, eos,
	0x13A2, 0xAB72, eos,
	0x13A3, 0xAB73, eos,	//  3220
	0x13A4, 0xAB74, eos,
	0x13A5, 0xAB75, eos,
	0x13A6, 0xAB76, eos,
	0x13A7, 0xAB77, eos,	//  3232
	0x13A8, 0xAB78, eos,
	0x13A9, 0xAB79, eos,
	0x13AA, 0xAB7A, eos,	//  3241
	0x13AB, 0xAB7B, eos,
	0x13AC, 0xAB7C, eos,
	0x13AD, 0xAB7D, eos,	//  3250
	0x13AE, 0xAB7E, eos,
	0x13AF, 0xAB7F, eos,
	0x13B0, 0xAB80, eos,
	0x13B1, 0xAB81, eos,	//  3262
	0x13B2, 0xAB82, eos,
	0x13B3, 0xAB83, eos,
	0x13B4, 0xAB84, eos,	//  3271
	0x13B5, 0xAB85, eos,
	0x13B6, 0xAB86, eos,
	0x13B7, 0xAB87, eos,	//  3280
	0x13B8, 0xAB88, eos,
	0x13B9, 0xAB89, eos,
	0x13BA, 0xAB8A, eos,
	0x13BB, 0xAB8B, eos,	//  3292
	0x13BC, 0xAB8C, eos,
	0x13BD, 0xAB8D, eos,
	0x13BE, 0xAB8E, eos,	//  3301
	0x13BF, 0xAB8F, eos,
	0x13C0, 0xAB90, eos,
	0x13C1, 0xAB91, eos,	//  3310
	0x13C2, 0xAB92, eos,
	0x13C3, 0xAB93, eos,
	0x13C4, 0xAB94, eos,
	0x13C5, 0xAB95, eos,	//  3322
	0x13C6, 0xAB96, eos,
	0x13C7, 0xAB97, eos,
	0x13C8, 0xAB98, eos,	//  3331
	0x13C9, 0xAB99, eos,
	0x13CA, 0xAB9A, eos,
	0x13CB, 0xAB9B, eos,	//  3340
	0x13CC, 0xAB9C, eos,
	0x13CD, 0xAB9D, eos,
	0x13CE, 0xAB9E, eos,
	0x13CF, 0xAB9F, eos,	//  3352
	0x13D0, 0xABA0, eos,
	0x13D1, 0xABA1, eos,
	0x13D2, 0xABA2, eos,	//  3361
	0x13D3, 0xABA3, eos,
	0x13D4, 0xABA4, eos,
	0x13D5, 0xABA5, eos,	//  3370
	0x13D6, 0xABA6, eos,
	0x13D7, 0xABA7, eos,
	0x13D8, 0xABA8, eos,
	0x13D9, 0xABA9, eos,	//  3382
	0x13DA, 0xABAA, eos,
	0x13DB, 0xABAB, eos,
	0x13DC, 0xABAC, eos,	//  3391
	0x13DD, 0xABAD, eos,
	0x13DE, 0xABAE, eos,
	0x13DF, 0xABAF, eos,	//  3400
	0x13E0, 0xABB0, eos,
	0x13E1, 0xABB1, eos,
	0x13E2, 0xABB2, eos,
	0x13E3, 0xABB3, eos,	//  3412
	0x13E4, 0xABB4, eos,
	0x13E5, 0xABB5, eos,
	0x13E6, 0xABB6, eos,	//  3421
	0x13E7, 0xABB7, eos,
	0x13E8, 0xABB8, eos,
	0x13E9, 0xABB9, eos,	//  3430
	0x13EA, 0xABBA, eos,
	0x13EB, 0xABBB, eos,
	0x13EC, 0xABBC, eos,
	0x13ED, 0xABBD, eos,	//  3442
	0x13EE, 0xABBE, eos,
	0x13EF, 0xABBF, eos,
	0xFB06, 0xFB05, eos,	//  3451
	0xFF41, 0xFF21, eos,
	0xFF42, 0xFF22, eos,
	0xFF43, 0xFF23, eos,	//  3460
	0xFF44, 0xFF24, eos,
	0xFF45, 0xFF25, eos,
	0xFF46, 0xFF26, eos,
	0xFF47, 0xFF27, eos,	//  3472
	0xFF48, 0xFF28, eos,
	0xFF49, 0xFF29, eos,
	0xFF4A, 0xFF2A, eos,	//  3481
	0xFF4B, 0xFF2B, eos,
	0xFF4C, 0xFF2C, eos,
	0xFF4D, 0xFF2D, eos,	//  3490
	0xFF4E, 0xFF2E, eos,
	0xFF4F, 0xFF2F, eos,
	0xFF50, 0xFF30, eos,
	0xFF51, 0xFF31, eos,	//  3502
	0xFF52, 0xFF32, eos,
	0xFF53, 0xFF33, eos,
	0xFF54, 0xFF34, eos,	//  3511
	0xFF55, 0xFF35, eos,
	0xFF56, 0xFF36, eos,
	0xFF57, 0xFF37, eos,	//  3520
	0xFF58, 0xFF38, eos,
	0xFF59, 0xFF39, eos,
	0xFF5A, 0xFF3A, eos,
	0x10428, 0x10400, eos,	//  3532
	0x10429, 0x10401, eos,
	0x1042A, 0x10402, eos,
	0x1042B, 0x10403, eos,	//  3541
	0x1042C, 0x10404, eos,
	0x1042D, 0x10405, eos,
	0x1042E, 0x10406, eos,	//  3550
	0x1042F, 0x10407, eos,
	0x10430, 0x10408, eos,
	0x10431, 0x10409, eos,
	0x10432, 0x1040A, eos,	//  3562
	0x10433, 0x1040B, eos,
	0x10434, 0x1040C, eos,
	0x10435, 0x1040D, eos,	//  3571
	0x10436, 0x1040E, eos,
	0x10437, 0x1040F, eos,
	0x10438, 0x10410, eos,	//  3580
	0x10439, 0x10411, eos,
	0x1043A, 0x10412, eos,
	0x1043B, 0x10413, eos,
	0x1043C, 0x10414, eos,	//  3592
	0x1043D, 0x10415, eos,
	0x1043E, 0x10416, eos,
	0x1043F, 0x10417, eos,	//  3601
	0x10440, 0x10418, eos,
	0x10441, 0x10419, eos,
	0x10442, 0x1041A, eos,	//  3610
	0x10443, 0x1041B, eos,
	0x10444, 0x1041C, eos,
	0x10445, 0x1041D, eos,
	0x10446, 0x1041E, eos,	//  3622
	0x10447, 0x1041F, eos,
	0x10448, 0x10420, eos,
	0x10449, 0x10421, eos,	//  3631
	0x1044A, 0x10422, eos,
	0x1044B, 0x10423, eos,
	0x1044C, 0x10424, eos,	//  3640
	0x1044D, 0x10425, eos,
	0x1044E, 0x10426, eos,
	0x1044F, 0x10427, eos,
	0x104D8, 0x104B0, eos,	//  3652
	0x104D9, 0x104B1, eos,
	0x104DA, 0x104B2, eos,
	0x104DB, 0x104B3, eos,	//  3661
	0x104DC, 0x104B4, eos,
	0x104DD, 0x104B5, eos,
	0x104DE, 0x104B6, eos,	//  3670
	0x104DF, 0x104B7, eos,
	0x104E0, 0x104B8, eos,
	0x104E1, 0x104B9, eos,
	0x104E2, 0x104BA, eos,	//  3682
	0x104E3, 0x104BB, eos,
	0x104E4, 0x104BC, eos,
	0x104E5, 0x104BD, eos,	//  3691
	0x104E6, 0x104BE, eos,
	0x104E7, 0x104BF, eos,
	0x104E8, 0x104C0, eos,	//  3700
	0x104E9, 0x104C1, eos,
	0x104EA, 0x104C2, eos,
	0x104EB, 0x104C3, eos,
	0x104EC, 0x104C4, eos,	//  3712
	0x104ED, 0x104C5, eos,
	0x104EE, 0x104C6, eos,
	0x104EF, 0x104C7, eos,	//  3721
	0x104F0, 0x104C8, eos,
	0x104F1, 0x104C9, eos,
	0x104F2, 0x104CA, eos,	//  3730
	0x104F3, 0x104CB, eos,
	0x104F4, 0x104CC, eos,
	0x104F5, 0x104CD, eos,
	0x104F6, 0x104CE, eos,	//  3742
	0x104F7, 0x104CF, eos,
	0x104F8, 0x104D0, eos,
	0x104F9, 0x104D1, eos,	//  3751
	0x104FA, 0x104D2, eos,
	0x104FB, 0x104D3, eos,
	0x10597, 0x10570, eos,	//  3760
	0x10598, 0x10571, eos,
	0x10599, 0x10572, eos,
	0x1059A, 0x10573, eos,
	0x1059B, 0x10574, eos,	//  3772
	0x1059C, 0x10575, eos,
	0x1059D, 0x10576, eos,
	0x1059E, 0x10577, eos,	//  3781
	0x1059F, 0x10578, eos,
	0x105A0, 0x10579, eos,
	0x105A1, 0x1057A, eos,	//  3790
	0x105A3, 0x1057C, eos,
	0x105A4, 0x1057D, eos,
	0x105A5, 0x1057E, eos,
	0x105A6, 0x1057F, eos,	//  3802
	0x105A7, 0x10580, eos,
	0x105A8, 0x10581, eos,
	0x105A9, 0x10582, eos,	//  3811
	0x105AA, 0x10583, eos,
	0x105AB, 0x10584, eos,
	0x105AC, 0x10585, eos,	//  3820
	0x105AD, 0x10586, eos,
	0x105AE, 0x10587, eos,
	0x105AF, 0x10588, eos,
	0x105B0, 0x10589, eos,	//  3832
	0x105B1, 0x1058A, eos,
	0x105B3, 0x1058C, eos,
	0x105B4, 0x1058D, eos,	//  3841
	0x105B5, 0x1058E, eos,
	0x105B6, 0x1058F, eos,
	0x105B7, 0x10590, eos,	//  3850
	0x105B8, 0x10591, eos,
	0x105B9, 0x10592, eos,
	0x105BB, 0x10594, eos,
	0x105BC, 0x10595, eos,	//  3862
	0x10CC0, 0x10C80, eos,
	0x10CC1, 0x10C81, eos,
	0x10CC2, 0x10C82, eos,	//  3871
	0x10CC3, 0x10C83, eos,
	0x10CC4, 0x10C84, eos,
	0x10CC5, 0x10C85, eos,	//  3880
	0x10CC6, 0x10C86, eos,
	0x10CC7, 0x10C87, eos,
	0x10CC8, 0x10C88, eos,
	0x10CC9, 0x10C89, eos,	//  3892
	0x10CCA, 0x10C8A, eos,
	0x10CCB, 0x10C8B, eos,
	0x10CCC, 0x10C8C, eos,	//  3901
	0x10CCD, 0x10C8D, eos,
	0x10CCE, 0x10C8E, eos,
	0x10CCF, 0x10C8F, eos,	//  3910
	0x10CD0, 0x10C90, eos,
	0x10CD1, 0x10C91, eos,
	0x10CD2, 0x10C92, eos,
	0x10CD3, 0x10C93, eos,	//  3922
	0x10CD4, 0x10C94, eos,
	0x10CD5, 0x10C95, eos,
	0x10CD6, 0x10C96, eos,	//  3931
	0x10CD7, 0x10C97, eos,
	0x10CD8, 0x10C98, eos,
	0x10CD9, 0x10C99, eos,	//  3940
	0x10CDA, 0x10C9A, eos,
	0x10CDB, 0x10C9B, eos,
	0x10CDC, 0x10C9C, eos,
	0x10CDD, 0x10C9D, eos,	//  3952
	0x10CDE, 0x10C9E, eos,
	0x10CDF, 0x10C9F, eos,
	0x10CE0, 0x10CA0, eos,	//  3961
	0x10CE1, 0x10CA1, eos,
	0x10CE2, 0x10CA2, eos,
	0x10CE3, 0x10CA3, eos,	//  3970
	0x10CE4, 0x10CA4, eos,
	0x10CE5, 0x10CA5, eos,
	0x10CE6, 0x10CA6, eos,
	0x10CE7, 0x10CA7, eos,	//  3982
	0x10CE8, 0x10CA8, eos,
	0x10CE9, 0x10CA9, eos,
	0x10CEA, 0x10CAA, eos,	//  3991
	0x10CEB, 0x10CAB, eos,
	0x10CEC, 0x10CAC, eos,
	0x10CED, 0x10CAD, eos,	//  4000
	0x10CEE, 0x10CAE, eos,
	0x10CEF, 0x10CAF, eos,
	0x10CF0, 0x10CB0, eos,
	0x10CF1, 0x10CB1, eos,	//  4012
	0x10CF2, 0x10CB2, eos,
	0x118C0, 0x118A0, eos,
	0x118C1, 0x118A1, eos,	//  4021
	0x118C2, 0x118A2, eos,
	0x118C3, 0x118A3, eos,
	0x118C4, 0x118A4, eos,	//  4030
	0x118C5, 0x118A5, eos,
	0x118C6, 0x118A6, eos,
	0x118C7, 0x118A7, eos,
	0x118C8, 0x118A8, eos,	//  4042
	0x118C9, 0x118A9, eos,
	0x118CA, 0x118AA, eos,
	0x118CB, 0x118AB, eos,	//  4051
	0x118CC, 0x118AC, eos,
	0x118CD, 0x118AD, eos,
	0x118CE, 0x118AE, eos,	//  4060
	0x118CF, 0x118AF, eos,
	0x118D0, 0x118B0, eos,
	0x118D1, 0x118B1, eos,
	0x118D2, 0x118B2, eos,	//  4072
	0x118D3, 0x118B3, eos,
	0x118D4, 0x118B4, eos,
	0x118D5, 0x118B5, eos,	//  4081
	0x118D6, 0x118B6, eos,
	0x118D7, 0x118B7, eos,
	0x118D8, 0x118B8, eos,	//  4090
	0x118D9, 0x118B9, eos,
	0x118DA, 0x118BA, eos,
	0x118DB, 0x118BB, eos,
	0x118DC, 0x118BC, eos,	//  4102
	0x118DD, 0x118BD, eos,
	0x118DE, 0x118BE, eos,
	0x118DF, 0x118BF, eos,	//  4111
	0x16E60, 0x16E40, eos,
	0x16E61, 0x16E41, eos,
	0x16E62, 0x16E42, eos,	//  4120
	0x16E63, 0x16E43, eos,
	0x16E64, 0x16E44, eos,
	0x16E65, 0x16E45, eos,
	0x16E66, 0x16E46, eos,	//  4132
	0x16E67, 0x16E47, eos,
	0x16E68, 0x16E48, eos,
	0x16E69, 0x16E49, eos,	//  4141
	0x16E6A, 0x16E4A, eos,
	0x16E6B, 0x16E4B, eos,
	0x16E6C, 0x16E4C, eos,	//  4150
	0x16E6D, 0x16E4D, eos,
	0x16E6E, 0x16E4E, eos,
	0x16E6F, 0x16E4F, eos,
	0x16E70, 0x16E50, eos,	//  4162
	0x16E71, 0x16E51, eos,
	0x16E72, 0x16E52, eos,
	0x16E73, 0x16E53, eos,	//  4171
	0x16E74, 0x16E54, eos,
	0x16E75, 0x16E55, eos,
	0x16E76, 0x16E56, eos,	//  4180
	0x16E77, 0x16E57, eos,
	0x16E78, 0x16E58, eos,
	0x16E79, 0x16E59, eos,
	0x16E7A, 0x16E5A, eos,	//  4192
	0x16E7B, 0x16E5B, eos,
	0x16E7C, 0x16E5C, eos,
	0x16E7D, 0x16E5D, eos,	//  4201
	0x16E7E, 0x16E5E, eos,
	0x16E7F, 0x16E5F, eos,
	0x1E922, 0x1E900, eos,	//  4210
	0x1E923, 0x1E901, eos,
	0x1E924, 0x1E902, eos,
	0x1E925, 0x1E903, eos,
	0x1E926, 0x1E904, eos,	//  4222
	0x1E927, 0x1E905, eos,
	0x1E928, 0x1E906, eos,
	0x1E929, 0x1E907, eos,	//  4231
	0x1E92A, 0x1E908, eos,
	0x1E92B, 0x1E909, eos,
	0x1E92C, 0x1E90A, eos,	//  4240
	0x1E92D, 0x1E90B, eos,
	0x1E92E, 0x1E90C, eos,
	0x1E92F, 0x1E90D, eos,
	0x1E930, 0x1E90E, eos,	//  4252
	0x1E931, 0x1E90F, eos,
	0x1E932, 0x1E910, eos,
	0x1E933, 0x1E911, eos,	//  4261
	0x1E934, 0x1E912, eos,
	0x1E935, 0x1E913, eos,
	0x1E936, 0x1E914, eos,	//  4270
	0x1E937, 0x1E915, eos,
	0x1E938, 0x1E916, eos,
	0x1E939, 0x1E917, eos,
	0x1E93A, 0x1E918, eos,	//  4282
	0x1E93B, 0x1E919, eos,
	0x1E93C, 0x1E91A, eos,
	0x1E93D, 0x1E91B, eos,	//  4291
	0x1E93E, 0x1E91C, eos,
	0x1E93F, 0x1E91D, eos,
	0x1E940, 0x1E91E, eos,	//  4300
	0x1E941, 0x1E91F, eos,
	0x1E942, 0x1E920, eos,
	0x1E943, 0x1E921, eos	//  4309
};
#define SRELL_UCFDATA_VERSION 201
