#ifndef __gui__pages__search_h
#define __gui__pages__search_h

#include "core/anime.h"

#include <QFrame>
#include <QAbstractListModel>
#include <QSortFilterProxyModel>
#include <QItemSelection>

class QTreeView;

class SearchPageListSortFilter final : public QSortFilterProxyModel {
		Q_OBJECT

	public:
		SearchPageListSortFilter(QObject* parent = nullptr);

	protected:
		bool lessThan(const QModelIndex& l, const QModelIndex& r) const override;
};

class SearchPageListModel final : public QAbstractListModel {
		Q_OBJECT

	public:
		enum columns {
			SR_TITLE,
			SR_TYPE,
			SR_EPISODES,
			SR_SCORE,
			SR_SEASON,

			NB_COLUMNS
		};

		SearchPageListModel(QObject* parent);
		~SearchPageListModel() override = default;
		int rowCount(const QModelIndex& parent = QModelIndex()) const override;
		int columnCount(const QModelIndex& parent = QModelIndex()) const override;
		QVariant data(const QModelIndex& index, int role) const override;
		QVariant headerData(const int section, const Qt::Orientation orientation, const int role) const override;
		Qt::ItemFlags flags(const QModelIndex& index) const override;

		void ParseSearch(const std::vector<int>& ids);
		Anime::Anime* GetAnimeFromIndex(const QModelIndex& index) const;

	private:
		std::vector<int> ids;
};

class SearchPage final : public QFrame {
		Q_OBJECT

	public:
		SearchPage(QWidget* parent = nullptr);
		void Search(const std::string& search);
		void DisplayListMenu();
		void ItemDoubleClicked();

	private:
		SearchPageListModel* model = nullptr;
		SearchPageListSortFilter* sort_model = nullptr;
		QTreeView* treeview = nullptr;
};
#endif // __gui__pages__search_h
