#ifndef MINORI_GUI_WIDGETS_ANIME_BUTTON_H_
#define MINORI_GUI_WIDGETS_ANIME_BUTTON_H_

#include <QFrame>
#include <QWidget>
#include <QLabel>

#include "gui/widgets/poster.h"
#include "gui/widgets/elided_label.h"
#include "gui/widgets/text.h"

namespace Anime {
class Anime;
}

class AnimeButton : public QFrame {
public:
	AnimeButton(QWidget* parent = nullptr);
	AnimeButton(const Anime::Anime& anime, QWidget* parent = nullptr);
	void SetAnime(const Anime::Anime& anime);

protected:
	Poster _poster;
	QLabel _title;
	TextWidgets::LabelledParagraph _info;
	ElidedLabel _synopsis;
};

#endif // MINORI_GUI_WIDGETS_ANIME_BUTTON_H_
