#ifndef MINORI_GUI_DIALOG_SETTINGS_H_
#define MINORI_GUI_DIALOG_SETTINGS_H_

#include "core/anime.h"
#include "core/config.h"
#include "core/session.h"
#include "gui/widgets/sidebar.h"
#include "gui/dialog/dialog.h"
#include <QDialogButtonBox>
#include <QLabel>
#include <QListWidget>
#include <QLocale>
#include <QStackedWidget>
#include <QTabWidget>
#include <QVBoxLayout>
#include <QWidget>

class SettingsPage : public QWidget {
	Q_OBJECT

public:
	SettingsPage(QWidget* parent = nullptr, QString title = "");
	void SetTitle(QString title);
	virtual void SaveInfo() = 0;
	void AddTab(QWidget* tab, QString title = "");

private:
	QLabel page_title_;
	QTabWidget tab_widget_;
	QVBoxLayout layout_;
};

class SettingsPageServices final : public SettingsPage {
	Q_OBJECT

public:
	SettingsPageServices(QWidget* parent = nullptr);
	void SaveInfo() override;

private:
	QWidget* CreateMainPage();
	QWidget* CreateAniListPage();
	QWidget* CreateKitsuPage();

	decltype(session.config.service) service;
};

class SettingsPageApplication final : public SettingsPage {
	Q_OBJECT

public:
	SettingsPageApplication(QWidget* parent = nullptr);
	void SaveInfo() override;

private:
	QWidget* CreateAnimeListWidget();
	QWidget* CreateGeneralWidget();

	Theme::Theme theme;
	QLocale locale;

	decltype(session.config.anime_list.score_format) format;
	decltype(session.config.anime_list.language) language;
	decltype(session.config.anime_list.display_aired_episodes) display_aired_episodes;
	decltype(session.config.anime_list.display_available_episodes) display_available_episodes;
	decltype(session.config.anime_list.highlight_anime_if_available) highlight_anime_if_available;
	decltype(session.config.anime_list.highlighted_anime_above_others) highlighted_anime_above_others;
};

class SettingsPageTorrents final : public SettingsPage {
	Q_OBJECT

public:
	SettingsPageTorrents(QWidget* parent = nullptr);
	void SaveInfo() override;

private:
	QWidget* CreateGeneralWidget();

	decltype(session.config.torrents.feed_link) feed_link;
};

class SettingsPageRecognition final : public SettingsPage {
	Q_OBJECT

public:
	SettingsPageRecognition(QWidget* parent = nullptr);
	void SaveInfo() override;

private:
	QWidget* CreatePlayersWidget();

	decltype(session.config.recognition.detect_media_players) detect_media_players;
	decltype(session.config.recognition.players) players;
};

class SettingsPageLibrary final : public SettingsPage {
	Q_OBJECT

public:
	SettingsPageLibrary(QWidget* parent = nullptr);
	void SaveInfo() override;

private:
	QWidget* CreateFoldersWidget();

	decltype(session.config.library.paths) paths;
	decltype(session.config.library.real_time_monitor) real_time_monitor;
};

class SettingsDialog final : public Dialog {
	Q_OBJECT

public:
	SettingsDialog(QWidget* parent = nullptr);
	QWidget* CreateServicesMainPage(QWidget* parent);
	void OnOK();

private:
	QVBoxLayout layout_;

	QWidget widget_;
	QHBoxLayout widget_layout_;

	SideBar sidebar_;
	QStackedWidget stacked_;

	SettingsPageServices services_page_;
	SettingsPageApplication application_page_;
	SettingsPageTorrents torrents_page_;
	SettingsPageRecognition recognition_page_;
	SettingsPageLibrary library_page_;

	QDialogButtonBox button_box_;
};

#endif // MINORI_GUI_DIALOG_SETTINGS_H_
