#include "core/json.h"

namespace JSON {

std::string GetString(nlohmann::json const& json, nlohmann::json::json_pointer const& ptr, std::string def) {
	if (json.contains(ptr) && json[ptr].is_string())
		return json[ptr].get<std::string>();
	else
		return def;
}

int GetInt(nlohmann::json const& json, nlohmann::json::json_pointer const& ptr, int def) {
	if (json.contains(ptr) && json[ptr].is_number())
		return json[ptr].get<int>();
	else
		return def;
}

bool GetBoolean(nlohmann::json const& json, nlohmann::json::json_pointer const& ptr, bool def) {
	if (json.contains(ptr) && json[ptr].is_boolean())
		return json[ptr].get<bool>();
	else
		return def;
}

double GetDouble(nlohmann::json const& json, nlohmann::json::json_pointer const& ptr, double def) {
	if (json.contains(ptr) && json[ptr].is_number())
		return json[ptr].get<double>();
	else
		return def;
}

} // namespace JSON
