#ifndef MINORI_GUI_WIDGETS_POSTER_H_
#define MINORI_GUI_WIDGETS_POSTER_H_
#include <QFrame>
#include <QImage>

#include "gui/widgets/clickable_label.h"

class QWidget;
namespace Anime {
class Anime;
}

class Poster final : public QFrame {
	Q_OBJECT

public:
	Poster(QWidget* parent = nullptr);
	Poster(const Anime::Anime& anime, QWidget* parent = nullptr);
	void SetAnime(const Anime::Anime& anime);
	void SetClickable(bool clickable);

protected:
	void resizeEvent(QResizeEvent*) override;
	void ImageDownloadFinished(const QByteArray& arr);
	void RenderToLabel();

private:
	QImage img_;
	QString service_url_;
	ClickableLabel label_;
	bool clickable_ = true;
};

#endif // MINORI_GUI_WIDGETS_POSTER_H_
