#ifndef __animia__animia__util_h
#define __animia__animia__util_h

#include <string>
#include <sstream>

namespace animia::internal::util {

bool ReadFile(const std::string& path, std::string& data);
bool EqualStrings(const std::string& str1, const std::string& str2);
bool Stem(const std::string& filename, std::string& stem);
bool CheckPattern(const std::string& pattern, const std::string& str);
bool TrimLeft(std::string& str, const char* chars);
bool TrimRight(std::string& str, const char* chars);

template<typename T = int,
         std::enable_if_t<std::is_integral<T>::value, bool> = true>
T StringToInt(const std::string& str, T def = 0) {
	std::istringstream s(str);
	s >> std::noboolalpha >> def;
	return def;
}

} // namespace animia::internal::util

#endif // __animia__animia__util_h
