#include "core/session.h"
#include "core/strings.h"
#include "gui/dialog/settings.h"

#include <QListWidget>
#include <QListWidgetItem>
#include <QGroupBox>
#include <QCheckBox>
#include <QLabel>
#include <QSizePolicy>
#include <QVBoxLayout>

#include <algorithm>

QWidget* SettingsPageRecognition::CreatePlayersWidget() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QVBoxLayout* full_layout = new QVBoxLayout(result);

	{
		/* Feed link */
		QWidget* widget = new QWidget(result);
		QVBoxLayout* widget_layout = new QVBoxLayout(widget);

		QCheckBox* checkbox = new QCheckBox(result);
		checkbox->setText(tr("Enable media player detection"));
		checkbox->setCheckState(detect_media_players ? Qt::Checked : Qt::Unchecked);
		widget_layout->addWidget(checkbox);

		{
			QLabel* label = new QLabel(tr("Allowed media players:"), widget);
			widget_layout->addWidget(label);
		}

		{
			QListWidget* listwidget = new QListWidget(widget);
			for (size_t i = 0; i < players.size(); i++) {
				const auto& [enabled, player] = players[i];
				if (player.type == animia::PlayerType::Default) {
					QListWidgetItem* item = new QListWidgetItem(listwidget);
					item->setCheckState(enabled ? Qt::Checked : Qt::Unchecked);
					item->setText(Strings::ToQString(player.name));
					item->setData(Qt::UserRole, QVariant::fromValue(i));
				}
			}
			connect(listwidget, &QListWidget::itemChanged, this, [this](QListWidgetItem* item){
				if (!item)
					return;
				size_t i = item->data(Qt::UserRole).toUInt();
				players[i].enabled = item->checkState();
			});
			/* this is down here because the listwidget state depends on it */
			connect(checkbox, &QCheckBox::stateChanged, this, [this, listwidget](int state) {
				detect_media_players = (state == Qt::Checked);
				listwidget->setEnabled(detect_media_players);
			});
			listwidget->setEnabled(checkbox->checkState() == Qt::Checked);

			widget_layout->addWidget(listwidget);
		}

		full_layout->addWidget(widget);
	}

	full_layout->setSpacing(10);

	return result;
}

void SettingsPageRecognition::SaveInfo() {
	session.config.recognition.detect_media_players = detect_media_players;
	session.config.recognition.players = players;
}

SettingsPageRecognition::SettingsPageRecognition(QWidget* parent)
	: SettingsPage(parent, tr("Recognition")),
	  players(session.config.recognition.players) {
	detect_media_players = session.config.recognition.detect_media_players;
	AddTab(CreatePlayersWidget(), tr("Media players"));
}
