#include "sys/osx/permissions.h"

#include <ApplicationServices/ApplicationServices.h>

#include <QCoreApplication>
#include <QMessageBox>
#include <QDesktopServices>
#include <QUrl>

namespace osx {

bool AskForPermissions() {
	if (::AXIsProcessTrusted())
		return true;

	QMessageBox msg;
	msg.setIcon(QMessageBox::Information);
	msg.setText(QCoreApplication::tr("Permissions needed!"));
	msg.setInformativeText(QCoreApplication::tr("Minori needs access to accessibility features for certain features to work. Open System Preferences?"));
	msg.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
	msg.setDefaultButton(QMessageBox::Yes);
	int ret = msg.exec();
	if (ret != QMessageBox::Yes)
		return false;

	QDesktopServices::openUrl(QUrl("x-apple.systempreferences:com.apple.preference.security?Privacy_Accessibility"));
	return true;
}

}
