#include "track/media.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include "core/session.h"

#include <QFile>
#include <QTextStream>

#include <string>
#include <unordered_map>
#include <vector>
#include <filesystem>

#include <iostream>

#include "animia.h"

namespace Track {
namespace Media {

static bool GetCurrentlyPlayingResults(std::vector<animia::Result>& results) {
	std::vector<animia::Player> players;

	players.reserve(session.config.recognition.players.size());
	for (const auto& [enabled, player] : session.config.recognition.players)
		if (enabled && player.type == animia::PlayerType::Default)
			players.push_back(player);

	if (!animia::GetResults(players, results))
		return false;

	return true;
}

/* meh */
bool GetCurrentlyPlaying(std::vector<std::string>& vec) {
	std::vector<animia::Result> results;

	if (!GetCurrentlyPlayingResults(results))
		return false;

	bool success = false;

	for (const auto& result : results) {
		for (const auto& media : result.media) {
			for (const auto& info : media.information) {
				switch (info.type) {
					case animia::MediaInfoType::File:
						vec.push_back(std::filesystem::path(info.value).filename().u8string());
						success |= true;
						break;
					case animia::MediaInfoType::Title:
						vec.push_back(info.value);
						success |= true;
						break;
					default:
						break;
				}
			}
		}
	}

	return success;
}

} // namespace Media
} // namespace Track
