#ifndef ANIMONE_ANIMONE_MEDIA_H_
#define ANIMONE_ANIMONE_MEDIA_H_

#include <chrono>
#include <functional>
#include <string>
#include <vector>

namespace animone {

// XXX where is this used?
using media_time_t = std::chrono::milliseconds;

enum class MediaInfoType {
	Unknown,
	File,
	Tab,
	Title,
	Url
};

struct MediaInfo {
	MediaInfoType type = MediaInfoType::Unknown;
	std::string value;
};

struct Media {
	std::vector<MediaInfo> information;
};

} // namespace animone

#endif // ANIMONE_ANIMONE_MEDIA_H_
