#include "animia/fd.h"

#ifdef WIN32
#	include "animia/fd/win32.h"
#endif

#ifdef LINUX
#	include "animia/fd/proc.h"
#endif

#ifdef MACOSX
#	include "animia/fd/xnu.h"
#endif

#ifdef LIBUTIL
#	include "animia/fd/libutil.h"
#endif

#ifdef LIBKVM
#	include "animia/fd/kvm.h"
#endif

namespace animia::internal {

bool EnumerateOpenFiles(const std::set<pid_t>& pids, open_file_proc_t open_file_proc) {
	bool success = false;

#ifdef WIN32
	success ^= win32::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef LINUX
	success ^= proc::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef MACOSX
	success ^= xnu::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef LIBUTIL
	success ^= libutil::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef LIBKVM
	success ^= kvm::EnumerateOpenFiles(pids, open_file_proc);
#endif

	return success;
}

bool EnumerateOpenProcesses(process_proc_t process_proc) {
	bool success = false;

#ifdef WIN32
	success ^= win32::EnumerateOpenProcesses(process_proc);
#endif

#ifdef LINUX
	success ^= proc::EnumerateOpenProcesses(process_proc);
#endif

#ifdef MACOSX
	success ^= xnu::EnumerateOpenProcesses(process_proc);
#endif

#ifdef LIBUTIL
	success ^= libutil::EnumerateOpenProcesses(process_proc);
#endif

#ifdef LIBKVM
	success ^= kvm::EnumerateOpenProcesses(process_proc);
#endif

	return success;
}

} // namespace animia::internal
