#include "animone/fd.h"

#ifdef USE_WIN32
#	include "animone/fd/win32.h"
#endif

#ifdef USE_LINUX
#	include "animone/fd/proc.h"
#endif

#ifdef USE_MACOSX
#	include "animone/fd/xnu.h"
#endif

#ifdef USE_BSD
#	include "animone/fd/bsd.h"
#endif

namespace animone::internal {

bool EnumerateOpenFiles(const std::set<pid_t>& pids, open_file_proc_t open_file_proc) {
	bool success = false;

#ifdef USE_WIN32
	success ^= win32::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef USE_LINUX
	success ^= proc::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef USE_MACOSX
	success ^= xnu::EnumerateOpenFiles(pids, open_file_proc);
#endif

#ifdef USE_BSD
	success ^= bsd::EnumerateOpenFiles(pids, open_file_proc);
#endif

	return success;
}

bool EnumerateOpenProcesses(process_proc_t process_proc) {
	bool success = false;

#ifdef USE_WIN32
	success ^= win32::EnumerateOpenProcesses(process_proc);
#endif

#ifdef USE_LINUX
	success ^= proc::EnumerateOpenProcesses(process_proc);
#endif

#ifdef USE_MACOSX
	success ^= xnu::EnumerateOpenProcesses(process_proc);
#endif

#ifdef USE_BSD
	success ^= bsd::EnumerateOpenProcesses(process_proc);
#endif

	return success;
}

bool GetProcessName(pid_t pid, std::string& name) {
	bool success = false;

#ifdef USE_WIN32
	success ^= win32::GetProcessName(pid, name);
#endif

#ifdef USE_LINUX
	success ^= proc::GetProcessName(pid, name);
#endif

#ifdef USE_MACOSX
	success ^= xnu::GetProcessName(pid, name);
#endif

#ifdef USE_BSD
	success ^= bsd::GetProcessName(pid, name);
#endif

	return success;
}

} // namespace animone::internal
