#include "gui/dialog/licenses.h"
#include "core/json.h"
#include "core/session.h"
#include "core/strings.h"
#include "gui/widgets/text.h"

#include "pugixml.hpp"

#include "utf8proc.h"

#include <fmt/core.h>

#include <QCoreApplication>
#include <QFont>
#include <QHBoxLayout>
#include <QTabWidget>
#include <QTextBrowser>
#include <QTextCharFormat>
#include <QTextCursor>

#include <curl/curl.h>
#ifdef WIN32
#	include "sys/win32/dark_theme.h"
#endif

static QWidget *create_license_widget(QWidget *parent, const std::string& license) {
	QTextBrowser* paragraph = new QTextBrowser(parent);
	paragraph->setFrameShape(QFrame::NoFrame);
	paragraph->setPlainText(Strings::ToQString(license));
	paragraph->setFont(QFont("monospace"));
	return paragraph;
}

LicensesWindow::LicensesWindow(QWidget* parent) : QDialog(parent) {
	resize(641, 500);
	setWindowTitle(tr("About Minori"));
	setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint | Qt::WindowCloseButtonHint);
	setAutoFillBackground(true);

	QHBoxLayout* layout = new QHBoxLayout(this);

	setBackgroundRole(QPalette::Base);

	QTabWidget *tab_widget = new QTabWidget(this);

	layout->addWidget(tab_widget);

	do {
		QFile f(":/licenses/LICENSE.minori");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("Minori"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.MIT.animone");
		QFile b(":/licenses/LICENSE.BSD.animone");
		if (!f.exists() || !b.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		b.open(QFile::ReadOnly | QFile::Text);

		std::string mit = Strings::ToUtf8String(f.readAll());
		std::string bsd = Strings::ToUtf8String(b.readAll());

		QWidget *dual = new QWidget(this);
		QVBoxLayout *dual_layout = new QVBoxLayout(dual);

		QLabel *dual_notice = new QLabel(tr("Animone was originally forked from Anisthesia, where any changes divergent from Anisthesia are now under a different license. Both the licenses for Animone and Anisthesia are provided below, respectfully:"), dual);
		dual_notice->setWordWrap(true);
		dual_layout->addWidget(dual_notice);
		dual_layout->addWidget(create_license_widget(dual, bsd));
		dual_layout->addWidget(create_license_widget(dual, mit));

		tab_widget->addTab(dual, tr("Animone"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.anitomy");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("Anitomy"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.fmt");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("fmt"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.nlohmann");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("JSON for Modern C++"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.pugixml");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("pugixml"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.semver");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("semver"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.toml11");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("toml11"));
	} while (0);

	do {
		QFile f(":/licenses/LICENSE.utf8proc");
		if (!f.exists())
			break;

		f.open(QFile::ReadOnly | QFile::Text);
		tab_widget->addTab(create_license_widget(this, Strings::ToUtf8String(f.readAll())), tr("utf8proc"));
	} while (0);
}

void LicensesWindow::showEvent(QShowEvent* event) {
	QDialog::showEvent(event);
#ifdef WIN32
	win32::SetTitleBarsToBlack(session.config.theme.IsInDarkTheme());
#endif
}
