#ifndef MINORI_CORE_ANIME_DB_H_
#define MINORI_CORE_ANIME_DB_H_

#include "core/anime.h"
#include "json/json_fwd.hpp"
#include <string>
#include <unordered_map>

namespace Anime {

class Database {
public:
	std::unordered_map<int, Anime> items;
	size_t GetTotalAnimeAmount();
	size_t GetTotalEpisodeAmount();
	size_t GetTotalWatchedAmount();
	size_t GetTotalPlannedAmount();
	double GetAverageScore();
	double GetScoreDeviation();
	size_t GetListsAnimeAmount(ListStatus status);
	int GetAnimeFromTitle(const std::string& title);

	bool GetDatabaseAsJSON(nlohmann::json& json);
	bool SaveDatabaseToDisk();

	bool ParseDatabaseJSON(const nlohmann::json& json);
	bool LoadDatabaseFromDisk();

	/* These are here to make sure that our service IDs don't collide
	 * and make the whole thing go boom. */
	int GetUnusedId();
	int LookupServiceId(Service service, const std::string& id_to_find);
	int LookupServiceIdOrUnused(Service service, const std::string& id_to_find);
};

extern Database db;

} // namespace Anime

#endif // MINORI_CORE_ANIME_DB_H_
