#include "gui/widgets/anime_info.h"
#include "core/anime.h"
#include "core/strings.h"
#include "gui/translate/anime.h"
#include "gui/widgets/text.h"
#include <QHBoxLayout>
#include <QTextStream>

AnimeInfoWidget::AnimeInfoWidget(QWidget* parent)
	: QWidget(parent)
	, _title(tr("Alternative titles"), "")
	, _details(tr("Details"), tr("Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:"), "")
	, _synopsis(tr("Synopsis"), "") {
	QVBoxLayout* layout = new QVBoxLayout(this);

	layout->addWidget(&_title);
	layout->addWidget(&_details);
	layout->addWidget(&_synopsis);
}

AnimeInfoWidget::AnimeInfoWidget(const Anime::Anime& anime, QWidget* parent) : AnimeInfoWidget(parent) {
	SetAnime(anime);
}

void AnimeInfoWidget::SetAnime(const Anime::Anime& anime) {
	/* alt titles */
	_title.GetLine()->SetText(Strings::ToQString(Strings::Implode(anime.GetTitleSynonyms(), ", ")));

	/* details */
	QString details_data;
	QTextStream details_data_s(&details_data);

	/* we have to convert ALL of these strings to
	 * QString because QTextStream sucks and assumes
	 * Latin1 (on Windows?) */
	const auto genres = anime.GetGenres();
	details_data_s << Strings::ToQString(Translate::ToLocalString(anime.GetFormat())) << "\n"
	               << anime.GetEpisodes() << "\n"
	               << Strings::ToQString(Translate::ToLocalString(anime.GetAiringStatus())) << "\n"
	               << Strings::ToQString(Translate::ToLocalString(anime.GetSeason())) << " "
	               << anime.GetAirDate().GetYear().value_or(2000) << "\n"
	               << Strings::ToQString((genres.size() > 1) ? Strings::Implode(genres, ", ") : "-") << "\n"
	               << anime.GetAudienceScore() << "%";
	_details.GetData()->setText(details_data);

	_synopsis.GetParagraph()->SetText(Strings::ToQString(anime.GetSynopsis()));

	updateGeometry();
}
