#include "gui/translate/anilist.h"
#include <unordered_map>

namespace Translate {
namespace AniList {

Anime::SeriesStatus ToSeriesStatus(const std::string& status) {
	static const std::unordered_map<std::string, Anime::SeriesStatus> map = {
	    {"FINISHED",         Anime::SeriesStatus::Finished        },
	    {"RELEASING",        Anime::SeriesStatus::Releasing       },
	    {"NOT_YET_RELEASED", Anime::SeriesStatus::NotYetReleased},
	    {"CANCELLED",        Anime::SeriesStatus::Cancelled       },
	    {"HIATUS",           Anime::SeriesStatus::Hiatus          }
    };

	if (map.find(status) == map.end())
		return Anime::SeriesStatus::Unknown;
	return map.at(status);
}

Anime::SeriesSeason ToSeriesSeason(const std::string& season) {
	static const std::unordered_map<std::string, Anime::SeriesSeason> map = {
	    {"WINTER", Anime::SeriesSeason::Winter},
	    {"SPRING", Anime::SeriesSeason::Spring},
	    {"SUMMER", Anime::SeriesSeason::Summer},
	    {"FALL",   Anime::SeriesSeason::Fall  }
    };

	if (map.find(season) == map.end())
		return Anime::SeriesSeason::Unknown;
	return map.at(season);
}

Anime::SeriesFormat ToSeriesFormat(const std::string& format) {
	static const std::unordered_map<std::string, enum Anime::SeriesFormat> map = {
	    {"TV",       Anime::SeriesFormat::Tv      },
        {"TV_SHORT", Anime::SeriesFormat::TvShort},
	    {"MOVIE",    Anime::SeriesFormat::Movie   },
        {"SPECIAL",  Anime::SeriesFormat::Special },
	    {"OVA",      Anime::SeriesFormat::Ova     },
        {"ONA",      Anime::SeriesFormat::Ona     },
	    {"MUSIC",    Anime::SeriesFormat::Music   }
    };

	if (map.find(format) == map.end())
		return Anime::SeriesFormat::Unknown;
	return map.at(format);
}

std::string ToString(Anime::SeriesSeason season) {
	switch (season) {
		default:
		case Anime::SeriesSeason::Winter: return "WINTER";
		case Anime::SeriesSeason::Fall: return "FALL";
		case Anime::SeriesSeason::Summer: return "SUMMER";
		case Anime::SeriesSeason::Spring: return "SPRING";
	}
}

} // namespace AniList
} // namespace Translate
