#ifndef __sidebar_h
#define __sidebar_h
#include <QListWidget>
#include <QListWidgetItem>
#include <QItemSelectionModel>
class SideBar : public QListWidget {
	Q_OBJECT

	public:
		SideBar(QWidget *parent = nullptr);
		QListWidgetItem* AddItem(QString name, QIcon icon = QIcon());
		QListWidgetItem* AddSeparator();
		bool IndexIsSeparator(QModelIndex index) const;

	signals:
		void CurrentItemChanged(int index);

	protected:
		virtual void mouseMoveEvent(QMouseEvent* event) override;
		QItemSelectionModel::SelectionFlags selectionCommand(const QModelIndex & index, const QEvent * event) const override;
		int RemoveSeparatorsFromIndex(int index);
};
#endif // __sidebar_h
