#ifndef __ui_utils_h
#define __ui_utils_h
#include <QLabel>
#include <QFrame>
#include <QWidget>
#include <QString>
#include <QPoint>
#include <QSize>
#include <QDateTime>
#include <QIcon>
#include <QPlainTextEdit>
namespace UiUtils {
	QIcon CreateSideBarIcon(const char* file);
	bool IsInDarkMode();
	std::string GetLengthFromQDateTime(QDateTime stamp);
	void SetPlainTextEditData(QPlainTextEdit* text_edit, QString data);

	class Header : public QWidget {
		public:
			Header(QString title, QWidget* parent = nullptr);
			void SetTitle(QString title);

		private:
			QLabel* static_text_title;
			QFrame* static_text_line;
	};

	class Paragraph : public QPlainTextEdit {
		public:
			Paragraph(QString text, QWidget* parent = nullptr);
			QSize minimumSizeHint() const override;
			QSize sizeHint() const override;
	};

	/* Convenience class that combines Paragraph and Header.
	   Fairly awful naming, but meh :') */
	class TextParagraph : public QWidget {
		public:
			TextParagraph(QString title, QString data, QWidget* parent = nullptr);
			Header* GetHeader();
			Paragraph* GetParagraph();

		private:
			Header* header;
			Paragraph* paragraph;
	};

	class LabelledTextParagraph : public QWidget {
		public:
			LabelledTextParagraph(QString title, QString label, QString data, QWidget* parent = nullptr);
			Header* GetHeader();
			Paragraph* GetLabels();
			Paragraph* GetParagraph();

		private:
			Header* header;
			Paragraph* labels;
			Paragraph* paragraph;
	};

	class SelectableTextParagraph : public QWidget {
		public:
			SelectableTextParagraph(QString title, QString data, QWidget* parent = nullptr);
			Header* GetHeader();
			Paragraph* GetParagraph();

		private:
			Header* header;
			Paragraph* paragraph;
	};
};
#endif // __ui_utils_h