#include <sstream>
#include <QWidget>
#include <QTimer>
#include <QTextStream>
#include <QString>
#include <QTextDocument>
#include <QVBoxLayout>
#include "anime_list.h"
#include "ui_utils.h"
#include "statistics.h"
#include "session.h"

StatisticsWidget::StatisticsWidget(AnimeListWidget* listwidget, QWidget* parent)
	: QFrame(parent) {
	setLayout(new QVBoxLayout);
	anime_list = listwidget;

	setFrameShape(QFrame::Panel);
	setFrameShadow(QFrame::Plain);

	UiUtils::LabelledTextParagraph* anime_list_pg = new UiUtils::LabelledTextParagraph("Anime list", "Anime count:\nEpisode count:\nTime spent watching:\nTime to complete:\nAverage score:\nScore deviation:", "", this);
	anime_list_data = anime_list_pg->GetParagraph();

	UiUtils::LabelledTextParagraph* application_pg = new UiUtils::LabelledTextParagraph("Weeaboo", "Uptime:", "", this);
	application_data = application_pg->GetParagraph();

	layout()->addWidget(anime_list_pg);
	layout()->addWidget(application_pg);
	((QBoxLayout*)layout())->addStretch();

	QPalette pal = QPalette();
	pal.setColor(QPalette::Window, Qt::white);
	setAutoFillBackground(true); 
	setPalette(pal);

	UpdateStatistics(); // load in statistics as soon as possible

	QTimer* timer = new QTimer(this);
	connect(timer, &QTimer::timeout, this, [this]{
		if (isVisible())
			UpdateStatistics();
	});
	timer->start(1000); // update statistics every second
}

#define ADD_TIME_SEGMENT(r, x, s, p) \
	if (x.count() > 0) \
		r << x.count() << ((x.count() == 1) ? s : p)
std::string StatisticsWidget::MinutesToDateString(int minutes) {
	/* NOTE: these duration_casts may not be needed... */
	std::chrono::duration<int, std::ratio<60>> int_total_mins(minutes);
	auto int_years = std::chrono::duration_cast<std::chrono::years>(int_total_mins);
	auto int_months = std::chrono::duration_cast<std::chrono::months>(int_total_mins-int_years);
	auto int_days = std::chrono::duration_cast<std::chrono::days>(int_total_mins-int_years-int_months);
	auto int_hours = std::chrono::duration_cast<std::chrono::hours>(int_total_mins-int_years-int_months-int_days);
	auto int_minutes = std::chrono::duration_cast<std::chrono::minutes>(int_total_mins-int_years-int_months-int_days-int_hours);
	std::ostringstream return_stream;
	ADD_TIME_SEGMENT(return_stream, int_years, " year ", " years ");
	ADD_TIME_SEGMENT(return_stream, int_months, " month ", " months ");
	ADD_TIME_SEGMENT(return_stream, int_days, " day ", " days ");
	ADD_TIME_SEGMENT(return_stream, int_hours, " hour ", " hours ");
	if (int_minutes.count() > 0 || return_stream.str().size() == 0)
		return_stream << int_minutes.count() << ((int_minutes.count() == 1) ? " minute" : " minutes");
	return return_stream.str();
}

std::string StatisticsWidget::SecondsToDateString(int seconds) {
	/* this is all fairly unnecessary, but works:tm: */
	std::chrono::duration<int, std::ratio<1>> int_total_mins(seconds);
	auto int_years = std::chrono::duration_cast<std::chrono::years>(int_total_mins);
	auto int_months = std::chrono::duration_cast<std::chrono::months>(int_total_mins-int_years);
	auto int_days = std::chrono::duration_cast<std::chrono::days>(int_total_mins-int_years-int_months);
	auto int_hours = std::chrono::duration_cast<std::chrono::hours>(int_total_mins-int_years-int_months-int_days);
	auto int_minutes = std::chrono::duration_cast<std::chrono::minutes>(int_total_mins-int_years-int_months-int_days-int_hours);
	auto int_seconds = std::chrono::duration_cast<std::chrono::seconds>(int_total_mins-int_years-int_months-int_days-int_hours-int_minutes);
	std::ostringstream return_stream;
	ADD_TIME_SEGMENT(return_stream, int_years, " year ", " years ");
	ADD_TIME_SEGMENT(return_stream, int_months, " month ", " months ");
	ADD_TIME_SEGMENT(return_stream, int_days, " day ", " days ");
	ADD_TIME_SEGMENT(return_stream, int_hours, " hour ", " hours ");
	ADD_TIME_SEGMENT(return_stream, int_minutes, " minute ", " minutes ");
	if (int_seconds.count() > 0 || return_stream.str().size() == 0)
		return_stream << int_seconds.count() << ((int_seconds.count() == 1) ? " second" : " seconds");
	return return_stream.str();
}
#undef ADD_TIME_SEGMENT

void StatisticsWidget::UpdateStatistics() {
	/* Anime list */
	QString string = "";
	QTextStream ts(&string);
	ts << anime_list->GetTotalAnimeAmount() << '\n';
	ts << anime_list->GetTotalEpisodeAmount() << '\n';
	ts << MinutesToDateString(anime_list->GetTotalWatchedAmount()).c_str() << '\n';
	ts << MinutesToDateString(anime_list->GetTotalPlannedAmount()).c_str() << '\n';
	ts << anime_list->GetAverageScore() << '\n';
	ts << anime_list->GetScoreDeviation() << '\n';
	UiUtils::SetPlainTextEditData(anime_list_data, string);

	/* Application */
	//UiUtils::SetPlainTextEditData(application_data, QString::number(session.uptime() / 1000));
	UiUtils::SetPlainTextEditData(application_data, QString(SecondsToDateString(session.uptime() / 1000).c_str()));
}
