#ifndef MINORI_GUI_LOCALE_H_
#define MINORI_GUI_LOCALE_H_

#include <QLocale>
#include <QTranslator>
#include <memory>
#include <string>
#include <vector>

namespace Locale {

std::string GetLocaleFullName(const QLocale& locale);

class Locale {
public:
	Locale();
	Locale(const std::string& name);
	QLocale GetLocale() const;
	std::vector<QLocale> GetAvailableLocales() const;
	void RefreshAvailableLocales(); // why would this ever be called?
	bool IsLocaleAvailable(const QLocale& locale) const;
	bool SetActiveLocale(const QLocale& locale);

private:
	bool SwitchTranslator(QTranslator& translator, const QString& name);

	QTranslator _translator;
	QTranslator _translator_qt;
	QLocale _locale;
	std::vector<QLocale> _available_translations = {};
};

} // namespace Locale

#endif // MINORI_GUI_LOCALE_H_
