#!/bin/sh
#
# deploy_build.sh:
# run this in your build dir to get a usable app bundle

SCRIPT_DIR=$(dirname -- "$0")
BUNDLE_NAME="Minori"

cp -r "$SCRIPT_DIR/../../rc/osx/$BUNDLE_NAME.app" .

mkdir -p "$BUNDLE_NAME.app/Contents/MacOS"
cp ".libs/minori" "$BUNDLE_NAME.app/Contents/MacOS/minori"

mkdir -p "$BUNDLE_NAME.app/Contents/Frameworks"
for i in animia pugixml anitomy; do
	cp "dep/$i/.libs/lib$i.0.dylib" "$BUNDLE_NAME.app/Contents/Frameworks"
	install_name_tool -change "/usr/local/lib/lib$i.0.dylib" "@executable_path/../Frameworks/lib$i.0.dylib" "$BUNDLE_NAME.app/Contents/MacOS/minori"
done

macdeployqt "$BUNDLE_NAME.app"
