#ifndef MINORI_GUI_THEME_H_
#define MINORI_GUI_THEME_H_

#include <array>

namespace Theme {

enum class Theme {
	Default,
	Light,
	Dark
};

constexpr std::array<Theme, 3> Themes{
	Theme::Default,
	Theme::Light,
	Theme::Dark
};

class ThemeManager final {
public:
	ThemeManager(Theme theme = Theme::Default);
	void SetTheme(Theme theme);
	Theme GetTheme() const;
	bool IsInDarkTheme() const;
	void RepaintCurrentTheme();

private:
	void SetToDarkTheme();
	void SetToLightTheme();
	void SetStyleSheet(Theme theme);
	Theme GetCurrentOSTheme() const;
	Theme theme;
};

} // namespace Theme

#endif // MINORI_GUI_THEME_H_
