#!/bin/sh
#
# deploys needed libraries for minori on win32
#
# this also runs windeployqt to deploy qt crap
# as well
#
# note: ldd is NOT a standard ldd; it's mingw-ldd
# from pypi which works much well when cross
# compiling using something like quasi-msys2

# you can override the paths to these at runtime
DIR="${DIR:-minori}"
LDD="${LDD:-mingw-ldd}"

GetNeededLibraries() {
	# do not run this on untrusted executables.
	# see: ldd(1)
	system="$(echo "$MSYSTEM" | tr "[:upper:]" "[:lower:]")"
	"$LDD" --output-format ldd-like --dll-lookup-dirs "/$system/bin" -- "$1" | while IFS="" read -r dependency; do
		# trim whitespace, then get the value; mingw-ldd's "ldd-like" output doesn't use tabs like regular ldd
		lib="$(printf -- "%s" "$dependency" | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//' | cut -d' ' -f3)"
		case $lib in
			"/$system/"*)
				printf -- "$lib\n"
				;;
			*)
				;;
		esac
	done
}


if test -d "$DIR"; then
	rm -r "$DIR"
fi

mkdir "$DIR"

for lib in $(GetNeededLibraries ".libs/minori.exe"); do
	echo "copying '$lib' to $DIR"
	cp "$lib" "$DIR/"
done

cp ".libs/minori.exe" "$DIR/"

windeployqt "$DIR/minori.exe"

zip -r "$DIR.zip" "$DIR"
