#include "core/config.h"
#include "core/strings.h"
#include "gui/translate/config.h"

#include <QCoreApplication>

#include <unordered_map>

namespace Translate {

Theme::Theme ToTheme(const std::string& theme) {
	const std::unordered_map<std::string, Theme::Theme> map = {
	    {"Default", Theme::Theme::Default   },
        {"Light",   Theme::Theme::Light},
        {"Dark",    Theme::Theme::Dark }
    };

	if (map.find(theme) == map.end())
		return Theme::Theme::Default;
	return map.at(theme);
}

std::string ToString(const Theme::Theme& theme) {
	switch (theme) {
		default:
		case Theme::Theme::Default: return "Default";
		case Theme::Theme::Light: return "Light";
		case Theme::Theme::Dark: return "Dark";
	}
}

std::string ToLocalString(const Theme::Theme& theme) {
	switch (theme) {
		default:
		case Theme::Theme::Default: return Strings::Translate("Default");
		case Theme::Theme::Light: return Strings::Translate("Light");
		case Theme::Theme::Dark: return Strings::Translate("Dark");
	}
}

} // namespace Translate
