#include "gui/widgets/drop_list_widget.h"

#include <QDragMoveEvent>
#include <QDropEvent>
#include <QMimeData>
#include <QFileInfo>

/* currently this only sends local paths that are folders */

DroppableListWidget::DroppableListWidget(QWidget* parent) : QListWidget(parent) {
	setAcceptDrops(true);
}

void DroppableListWidget::dragMoveEvent(QDragMoveEvent* event) {
	if (event->mimeData()->hasUrls())
		event->acceptProposedAction();
}

void DroppableListWidget::dragEnterEvent(QDragEnterEvent* event) {
	if (event->mimeData()->hasUrls())
		event->acceptProposedAction();
}

void DroppableListWidget::dropEvent(QDropEvent* event) {
	const QMimeData* mime_data = event->mimeData();

	if (!mime_data->hasUrls())
		return;

	QStringList path_list;
	QList<QUrl> url_list = mime_data->urls();

	for (const auto& url : url_list) {
		if (!url.isLocalFile())
			continue;

		const QString file = url.toLocalFile();
		const QFileInfo fileinfo(file);
		if (fileinfo.exists() && fileinfo.isDir())
			path_list.append(file);
	}

	if (!path_list.isEmpty())
		emit FilesDropped(path_list);

	event->acceptProposedAction();
}