#!/bin/sh
#
# deploy_build.sh:
# run this in your build dir to get a usable app bundle

SCRIPT_DIR=$(dirname -- "$0")
FRAMEWORK_MODE=false
if test "x$1x" = "x--frameworksx"; then
	echo "framework mode enabled"
	FRAMEWORK_MODE=true
fi
BUNDLE_NAME="Minori"

cp -r "$SCRIPT_DIR/../../rc/sys/osx/$BUNDLE_NAME.app" .

mkdir -p "$BUNDLE_NAME.app/Contents/MacOS"
cp ".libs/minori" "$BUNDLE_NAME.app/Contents/MacOS/minori"

mkdir -p "$BUNDLE_NAME.app/Contents/Frameworks"
for i in animone pugixml anitomy; do
	cp "dep/$i/.libs/lib$i.0.dylib" "$BUNDLE_NAME.app/Contents/Frameworks"
	install_name_tool -change "/usr/local/lib/lib$i.0.dylib" "@executable_path/../Frameworks/lib$i.0.dylib" "$BUNDLE_NAME.app/Contents/MacOS/minori"
done

macdeployqt "$BUNDLE_NAME.app" -no-strip
if $FRAMEWORK_MODE; then
	for i in QtCore QtGui QtWidgets; do
		install_name_tool -id @executable_path/../Frameworks/$i.framework/Versions/5/$i $BUNDLE_NAME.app/Contents/Frameworks/$i.framework/Versions/5/$i
		install_name_tool -change @rpath/$i.framework/Versions/5/$i @executable_path/../Frameworks/$i.framework/Versions/5/$i $BUNDLE_NAME.app/Contents/MacOS/minori
	done
fi
