#ifndef __track__types_h
#define __track__types_h

#include <string>
#include <vector>

namespace Track {
namespace Types {

struct MediaPlayer {
	public:
		std::string GetName() const { return _name; };
		std::string GetExecutable() const { return _executable; };
		bool GetEnabled() const { return _enabled; };

		void SetName(const std::string& name) { _name = name; };
		void SetExecutable(const std::string& executable) { _executable = executable; };
		void SetEnabled(const bool enabled) { _enabled = enabled; };

	private:
		std::string _name;
		std::string _executable;
		bool _enabled;
};

struct MediaExtension {
	public:
		std::string GetExtension() const { return _extension; };
		bool GetEnabled() const { return _enabled; };

		void SetExtension(const std::string& extension) { _extension = extension; };
		void SetEnabled(const bool enabled) { _enabled = enabled; };

	private:
		std::string _extension;
		bool _enabled;
};

void LoadPlayers(std::vector<MediaPlayer>& players);
void LoadExtensions(std::vector<MediaExtension>& extensions);

void SavePlayers(const std::vector<MediaPlayer>& players);
void SaveExtensions(const std::vector<MediaExtension>& extensions);

}
}

#endif // __track__types_h