#include "gui/translate/anilist.h"

namespace Translate {
namespace AniList {

Anime::SeriesStatus ToSeriesStatus(std::string status) {
	const std::unordered_map<std::string, Anime::SeriesStatus> map = {
	    {"FINISHED",         Anime::SeriesStatus::FINISHED        },
	    {"RELEASING",        Anime::SeriesStatus::RELEASING       },
	    {"NOT_YET_RELEASED", Anime::SeriesStatus::NOT_YET_RELEASED},
	    {"CANCELLED",        Anime::SeriesStatus::CANCELLED       },
	    {"HIATUS",           Anime::SeriesStatus::HIATUS          }
    };

	if (map.find(status) == map.end())
		return Anime::SeriesStatus::UNKNOWN;
	return map.at(status);
}

Anime::SeriesSeason ToSeriesSeason(std::string season) {
	const std::unordered_map<std::string, Anime::SeriesSeason> map = {
	    {"WINTER", Anime::SeriesSeason::WINTER},
	    {"SPRING", Anime::SeriesSeason::SPRING},
	    {"SUMMER", Anime::SeriesSeason::SUMMER},
	    {"FALL",   Anime::SeriesSeason::FALL  }
    };

	if (map.find(season) == map.end())
		return Anime::SeriesSeason::UNKNOWN;
	return map.at(season);
}

Anime::SeriesFormat ToSeriesFormat(std::string format) {
	const std::unordered_map<std::string, enum Anime::SeriesFormat> map = {
	    {"TV",       Anime::SeriesFormat::TV      },
        {"TV_SHORT", Anime::SeriesFormat::TV_SHORT},
	    {"MOVIE",    Anime::SeriesFormat::MOVIE   },
        {"SPECIAL",  Anime::SeriesFormat::SPECIAL },
	    {"OVA",      Anime::SeriesFormat::OVA     },
        {"ONA",      Anime::SeriesFormat::ONA     },
	    {"MUSIC",    Anime::SeriesFormat::MUSIC   },
        {"MANGA",    Anime::SeriesFormat::MANGA   },
	    {"NOVEL",    Anime::SeriesFormat::NOVEL   },
        {"ONE_SHOT", Anime::SeriesFormat::ONE_SHOT}
    };

	if (map.find(format) == map.end())
		return Anime::SeriesFormat::UNKNOWN;
	return map.at(format);
}

} // namespace AniList
} // namespace Translate
