#ifndef __animia__animia_h
#define __animia__animia_h

#include "animia/media.h"
#include "animia/player.h"
#include "animia/types.h"

namespace animia {

enum class ResultType {
	Process,
	Window
};

struct Process {
	internal::pid_t pid = 0;
	std::string name;
};

struct Window {
	unsigned int id = 0;
	std::string class_name;
	std::string text; // title bar text
};

struct Result {
	ResultType type;
	Player player;
	Process process; // unused when using window_title. it's dumb, blame X11
	Window window; // unused with file descriptors
	std::vector<Media> media;
};

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results);

} // namespace animia

#endif // __animia__animia_h
