#include "track/media.h"
#include "track/constants.h"
#include "animia.h"
#include "anitomy/anitomy.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include "core/session.h"
#include <string>
#include <unordered_map>
#include <vector>
#include <iostream>
#include <QFile>
#include <QTextStream>

namespace Track {
namespace Media {

static bool GetCurrentlyPlayingResults(std::vector<animia::Result>& results) {
	std::vector<animia::Player> players;

	players.reserve(session.config.recognition.players.size());
	for (const auto& [enabled, player] : session.config.recognition.players)
		if (enabled && player.type == animia::PlayerType::Default)
			players.push_back(player);

	if (!animia::GetResults(players, results))
		return false;

	return true;
}

/* meh */
bool GetCurrentlyPlaying(std::vector<std::string>& vec) {
	std::vector<animia::Result> results;

	if (!GetCurrentlyPlayingResults(results))
		return false;

	bool success = false;

	for (const auto& result : results) {
		for (const auto& media : result.media) {
			for (const auto& info : media.information) {
				switch (info.type) {
					case 
				}
				std::cout << static_cast<int>(info.type) << ": " << info.value << std::endl;
				vec.push_back(info.value);
				success |= true;
			}
		}
	}

	return success;
}

} // namespace Media
} // namespace Track
