#include "library/library.h"
#include "core/anime_db.h"
#include "core/session.h"
#include "core/strings.h"

#include "anitomy/anitomy.h"

#include <filesystem>
#include <string>
#include <unordered_map>

#include <iostream>

namespace Library {

// int = anime id, map = episode, paths
std::unordered_map<int, std::unordered_map<int, std::string>> library;

void SearchLibraryFolders() {
	library.clear();

	for (const auto& folder : session.config.library.paths) {
		for (const auto& entry : std::filesystem::recursive_directory_iterator(folder)) {
			const std::filesystem::path path = entry.path();
			if (!std::filesystem::is_regular_file(path))
				continue;

			const std::string basename = path.filename().u8string();

			anitomy::Anitomy anitomy;
			anitomy.Parse(Strings::ToWstring(basename));

			const auto& elements = anitomy.elements();

			const std::string title = Strings::ToUtf8String(elements.get(anitomy::kElementAnimeTitle));

			const int id = Anime::db.LookupAnimeTitle(title);
			if (id <= 0)
				continue;

			const int episode = Strings::ToInt(Strings::ToUtf8String(elements.get(anitomy::kElementEpisodeNumber)));

			// we have an ID now!
			library[id][episode] = path.u8string();
		}
	}
}

} // namespace Library
