#ifndef MINORI_CORE_DATE_H_
#define MINORI_CORE_DATE_H_

#include "json/json_fwd.hpp"

#include "core/time.h"

#include <optional>
#include <string>

class QDate;

/* TODO: refactor constructors, as they aren't meant
 * to be used in this way and may cause problems down
 * the line */

class Date {
public:
	using Year = unsigned int;
	using Day = unsigned char;
	enum class Month {
		Jan = 0,
		Feb,
		Mar,
		Apr,
		May,
		Jun,
		Jul,
		Aug,
		Sep,
		Oct,
		Nov,
		Dec
	};

	Date();
	Date(Year y);
	Date(Year y, Month m, Day d);
	Date(const std::string &str);
	Date(const QDate &date);
	Date(const nlohmann::json &json);
	Date(Time::Timestamp timestamp);

	bool IsValid() const;

	void SetYear(Year y);
	void SetMonth(Month m);
	void SetDay(Day d);

	void VoidYear();
	void VoidMonth();
	void VoidDay();

	std::optional<Year> GetYear() const;
	std::optional<Month> GetMonth() const;
	std::optional<Day> GetDay() const;
	QDate GetAsQDate() const;
	nlohmann::json GetAsAniListJson() const;
	std::string GetAsISO8601() const;

private:
	std::optional<Year> year;
	std::optional<Month> month;
	std::optional<Day> day;
};

#endif // MINORI_CORE_DATE_H_
