#include "gui/widgets/anime_info.h"
#include "core/anime.h"
#include "core/strings.h"
#include "gui/translate/anime.h"
#include "gui/widgets/text.h"
#include <QHBoxLayout>
#include <QTextStream>

AnimeInfoWidget::AnimeInfoWidget(const Anime::Anime& anime, QWidget* parent) : QWidget(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);

	/* alt titles */
	TextWidgets::OneLineSection* title = new TextWidgets::OneLineSection(
	    tr("Alternative titles"), Strings::ToQString(Strings::Implode(anime.GetTitleSynonyms(), ", ").c_str()), this);
	layout->addWidget(title);

	/* details */
	QString details_data;
	QTextStream details_data_s(&details_data);
	details_data_s << Translate::ToString(anime.GetFormat()).c_str() << "\n"
	               << anime.GetEpisodes() << "\n"
	               << Translate::ToString(anime.GetUserStatus()).c_str() << "\n"
	               << Translate::ToString(anime.GetSeason()).c_str() << " " << anime.GetAirDate().GetYear() << "\n"
	               << Strings::Implode(anime.GetGenres(), ", ").c_str() << "\n"
	               << anime.GetAudienceScore() << "%";
	layout->addWidget(new TextWidgets::LabelledSection(
	    tr("Details"), tr("Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:"), details_data, this));

	/* synopsis */
	TextWidgets::SelectableSection* synopsis =
	    new TextWidgets::SelectableSection(tr("Synopsis"), QString::fromUtf8(anime.GetSynopsis().c_str()), this);

	synopsis->GetParagraph()->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	layout->addWidget(synopsis);
}

#include "gui/widgets/moc_anime_info.cpp"
