#ifndef __gui__widgets__optional_date_h
#define __gui__widgets__optional_date_h

#include "core/date.h"
#include <QWidget>

class QCheckBox;
class QDateEdit;
class QDate;

class OptionalDate : public QWidget {
		Q_OBJECT

	public:
		OptionalDate(QWidget* parent = nullptr);
		OptionalDate(bool enabled, QWidget* parent = nullptr);
		QDateEdit* GetDateEdit();
		QCheckBox* GetCheckBox();
		void SetDate(QDate date);
		void SetDate(Date date);
		Date GetDate();
		void SetEnabled(bool enabled);
		bool IsEnabled();

	signals:
		void DataChanged(bool checked, Date date);

	private:
		QDateEdit* _dateedit;
		QCheckBox* _checkbox;
};

#endif // __gui__widgets__optional_date_h
