#include "library/library.h"
#include "core/anime_db.h"
#include "core/strings.h"
#include "core/session.h"

#include "anitomy/anitomy.h"

#include <filesystem>
#include <unordered_map>
#include <string>

#include <iostream>

namespace Library {

// int = anime id, map = episode, paths
std::unordered_map<int, std::unordered_map<int, std::string>> library;

void SearchLibraryFolders() {
	library.clear();

	for (const auto& spath : session.config.library.paths) {
		const std::filesystem::path path(spath);
		for (const auto& entry : std::filesystem::recursive_directory_iterator(path)) {
			if (!std::filesystem::is_regular_file(entry.path()))
				continue;

			const std::string basename = entry.path().filename().string();

			anitomy::Anitomy anitomy;
			anitomy.Parse(Strings::ToWstring(basename));

			const auto& elements = anitomy.elements();

			const std::string title = Strings::ToUtf8String(elements.get(anitomy::kElementAnimeTitle));

			const int id = Anime::db.GetAnimeFromTitle(title);
			if (id <= 0)
				continue;

			const int episode = Strings::ToInt(Strings::ToUtf8String(elements.get(anitomy::kElementEpisodeNumber)));

			// we have an ID now!
			library[id][episode] = entry.path();
		}
	}
}

}
