#include "core/session.h"
#include "gui/dialog/settings.h"
#include "gui/dark_theme.h"
#include <QCheckBox>
#include <QComboBox>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QSizePolicy>
#include <QVBoxLayout>

QWidget* SettingsPageApplication::CreateAnimeListWidget() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QGroupBox* actions_group_box = new QGroupBox(tr("Actions"), result);
	actions_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	/* Actions/Double click */
	QWidget* double_click_widget = new QWidget(actions_group_box);
	QLabel* dc_combo_box_label = new QLabel(tr("Double click:"), double_click_widget);
	QComboBox* dc_combo_box = new QComboBox(double_click_widget);
	dc_combo_box->addItem(tr("View anime info"));

	QVBoxLayout* double_click_layout = new QVBoxLayout(double_click_widget);
	double_click_layout->addWidget(dc_combo_box_label);
	double_click_layout->addWidget(dc_combo_box);
	double_click_layout->setContentsMargins(0, 0, 0, 0);

	/* Actions/Middle click */
	QWidget* middle_click_widget = new QWidget(actions_group_box);
	QLabel* mc_combo_box_label = new QLabel(tr("Middle click:"), middle_click_widget);
	QComboBox* mc_combo_box = new QComboBox(middle_click_widget);
	mc_combo_box->addItem(tr("Play next episode"));

	QVBoxLayout* middle_click_layout = new QVBoxLayout(middle_click_widget);
	middle_click_layout->addWidget(mc_combo_box_label);
	middle_click_layout->addWidget(mc_combo_box);
	middle_click_layout->setContentsMargins(0, 0, 0, 0);

	/* Actions */
	QHBoxLayout* actions_layout = new QHBoxLayout(actions_group_box);
	actions_layout->addWidget(double_click_widget);
	actions_layout->addWidget(middle_click_widget);

	QGroupBox* appearance_group_box = new QGroupBox(tr("Appearance"), result);
	appearance_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QLabel* lang_combo_box_label = new QLabel(tr("Title language preference:"), appearance_group_box);
	QComboBox* lang_combo_box = new QComboBox(appearance_group_box);
	lang_combo_box->addItem(tr("Romaji"));
	lang_combo_box->addItem(tr("Native"));
	lang_combo_box->addItem(tr("English"));
	connect(lang_combo_box, QOverload<int>::of(&QComboBox::currentIndexChanged), this,
	        [this](int index) { language = static_cast<Anime::TitleLanguage>(index); });
	lang_combo_box->setCurrentIndex(static_cast<int>(language));

	QLabel* theme_combo_box_label = new QLabel(tr("Application theme:"), appearance_group_box);
	QComboBox* theme_combo_box = new QComboBox(appearance_group_box);
	theme_combo_box->addItem(tr("Default"));
	theme_combo_box->addItem(tr("Light"));
	theme_combo_box->addItem(tr("Dark"));
	connect(theme_combo_box, QOverload<int>::of(&QComboBox::currentIndexChanged), this,
		    [this](int index) { theme = static_cast<Themes>(index); });
	theme_combo_box->setCurrentIndex(static_cast<int>(theme));

	QCheckBox* hl_anime_box =
	    new QCheckBox(tr("Highlight anime if next episode is available in library folders"), appearance_group_box);
	QCheckBox* hl_above_anime_box = new QCheckBox(tr("Display highlighted anime above others"), appearance_group_box);
	connect(hl_anime_box, &QCheckBox::stateChanged, this, [this, hl_above_anime_box](int state) {
		highlight_anime_if_available = !(state == Qt::Unchecked);
		hl_above_anime_box->setEnabled(state);
	});
	connect(hl_above_anime_box, &QCheckBox::stateChanged, this,
	        [this](int state) { highlight_anime_if_available = !(state == Qt::Unchecked); });
	hl_anime_box->setCheckState(highlight_anime_if_available ? Qt::Checked : Qt::Unchecked);
	hl_above_anime_box->setCheckState(highlighted_anime_above_others ? Qt::Checked : Qt::Unchecked);
	hl_above_anime_box->setEnabled(hl_anime_box->checkState() != Qt::Unchecked);
	hl_above_anime_box->setContentsMargins(10, 0, 0, 0);

	/* Appearance */
	QVBoxLayout* appearance_layout = new QVBoxLayout(appearance_group_box);
	appearance_layout->addWidget(lang_combo_box_label);
	appearance_layout->addWidget(lang_combo_box);
	appearance_layout->addWidget(theme_combo_box_label);
	appearance_layout->addWidget(theme_combo_box);
	appearance_layout->addWidget(hl_anime_box);
	appearance_layout->addWidget(hl_above_anime_box);

	QGroupBox* progress_group_box = new QGroupBox(tr("Progress"), result);
	progress_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QCheckBox* progress_display_aired_episodes =
	    new QCheckBox(tr("Display aired episodes (estimated)"), progress_group_box);
	connect(progress_display_aired_episodes, &QCheckBox::stateChanged, this,
	        [this](int state) { display_aired_episodes = !(state == Qt::Unchecked); });
	progress_display_aired_episodes->setCheckState(display_aired_episodes ? Qt::Checked : Qt::Unchecked);

	QCheckBox* progress_display_available_episodes =
	    new QCheckBox(tr("Display available episodes in library folders"), progress_group_box);
	connect(progress_display_available_episodes, &QCheckBox::stateChanged, this,
	        [this](int state) { display_available_episodes = !(state == Qt::Unchecked); });
	progress_display_available_episodes->setCheckState(display_available_episodes ? Qt::Checked : Qt::Unchecked);

	QVBoxLayout* progress_layout = new QVBoxLayout(progress_group_box);
	progress_layout->addWidget(progress_display_aired_episodes);
	progress_layout->addWidget(progress_display_available_episodes);

	QVBoxLayout* full_layout = new QVBoxLayout(result);
	full_layout->addWidget(actions_group_box);
	full_layout->addWidget(appearance_group_box);
	full_layout->addWidget(progress_group_box);
	full_layout->setSpacing(10);
	full_layout->addStretch();

	return result;
}

void SettingsPageApplication::SaveInfo() {
	session.config.anime_list.language = language;
	session.config.anime_list.highlighted_anime_above_others = highlighted_anime_above_others;
	session.config.anime_list.highlight_anime_if_available = highlight_anime_if_available;
	session.config.anime_list.display_aired_episodes = display_aired_episodes;
	session.config.anime_list.display_available_episodes = display_available_episodes;
	session.config.theme = theme;
	DarkTheme::SetTheme(session.config.theme);
}

SettingsPageApplication::SettingsPageApplication(QWidget* parent) : SettingsPage(parent, tr("Application")) {
	language = session.config.anime_list.language;
	theme = session.config.theme;
	highlighted_anime_above_others = session.config.anime_list.highlighted_anime_above_others;
	highlight_anime_if_available = session.config.anime_list.highlight_anime_if_available;
	display_aired_episodes = session.config.anime_list.display_aired_episodes;
	display_available_episodes = session.config.anime_list.display_available_episodes;
	AddTab(CreateAnimeListWidget(), tr("Anime list"));
}
